<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_CarDealer_Search_Form_Tabs extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_cardealer_search_form_tabs';
    }

	public function get_title() {
        return esc_html__( 'Apus Listings Search Form Tabs', 'boxcar' );
    }
    
	public function get_categories() {
        return [ 'boxcar-elements' ];
    }

    public function get_conditions() {
        $args = [
            'taxonomy' => 'listing_condition',
            'hide_empty' => false,
            'meta_key'      => 'menu_order',
            'meta_compare'  => 'NUMERIC',
            'orderby'       => 'meta_value_num',
            'order'         => 'ASC',
        ];
        $conditions = get_terms( $args );
        return $conditions;
    }

	protected function register_controls() {

        
        $conditions = $this->get_conditions();

        $tabs = [0 => esc_html__('All Conditions', 'boxcar')];
        if ( !empty($conditions) ) {
            foreach ($conditions as $condition) {
                $tabs[$condition->slug] = $condition->name;
            }
        }

        $tab_repeater = new Elementor\Repeater();
        $tab_repeater->add_control(
            'tab_condition',
            [
                'label' => esc_html__( 'Condition', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $tabs
            ]
        );
        $tab_repeater->add_control(
            'tab_title',
            [
                'label' => esc_html__( 'Tab Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
            ]
        );
        

        

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Search Form Tabs', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tabs_search',
            [
                'label' => esc_html__( 'Tabs', 'boxcar' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'fields' => $tab_repeater->get_controls(),
            ]
        );

        $this->add_control(
            'active_tab',
            [
                'label' => esc_html__( 'Activate Tab', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $tabs,
                'default' => 0
            ]
        );

        $this->end_controls_section();


        $fields = apply_filters( 'wp-cardealer-default-listing-filter-fields', array() );
        $search_fields = array( '' => esc_html__('Choose a field', 'boxcar') );
        foreach ($fields as $key => $field) {
            if ( $key !== 'condition' ) {
                $name = $field['name'];
                if ( empty($field['name']) ) {
                    $name = $key;
                }
                $search_fields[$key] = $name;
            }
        }

        $repeater = new Elementor\Repeater();

        $repeater->add_control(
            'filter_field',
            [
                'label' => esc_html__( 'Filter field', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $search_fields
            ]
        );
        
        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
            ]
        );

        $repeater->add_control(
            'placeholder',
            [
                'label' => esc_html__( 'Placeholder', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
            ]
        );

        $repeater->add_control(
            'enable_autocompleate_search',
            [
                'label' => esc_html__( 'Enable autocompleate search', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Yes', 'boxcar' ),
                'label_off' => esc_html__( 'No', 'boxcar' ),
                'condition' => [
                    'filter_field' => 'title',
                ],
            ]
        );

        $repeater->add_control(
            'style',
            [
                'label' => esc_html__( 'Price Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => [
                    'slider' => esc_html__('Price Slider', 'boxcar'),
                    'text' => esc_html__('Pice Min/max Input Text', 'boxcar'),
                    'list' => esc_html__('Price List', 'boxcar'),
                ],
                'default' => 'slider',
                'condition' => [
                    'filter_field' => 'price',
                ],
            ]
        );
        $repeater->add_control(
            'price_range_size',
            [
                'label' => esc_html__( 'Price range size', 'boxcar' ),
                'type' => Elementor\Controls_Manager::NUMBER,
                'input_type' => 'text',
                'default' => 1000,
                'condition' => [
                    'filter_field' => 'price',
                    'style' => 'list',
                ],
            ]
        );
        $repeater->add_control(
            'price_range_max',
            [
                'label' => esc_html__( 'Max price ranges', 'boxcar' ),
                'type' => Elementor\Controls_Manager::NUMBER,
                'input_type' => 'text',
                'default' => 10,
                'condition' => [
                    'filter_field' => 'price',
                    'style' => 'list',
                ],
            ]
        );
        $repeater->add_control(
            'min_price_placeholder',
            [
                'label' => esc_html__( 'Min Price Placeholder', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Min Price',
                'condition' => [
                    'filter_field' => 'price',
                    'style' => 'text',
                ],
            ]
        );

        $repeater->add_control(
            'max_price_placeholder',
            [
                'label' => esc_html__( 'Max Price Placeholder', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Max Price',
                'condition' => [
                    'filter_field' => 'price',
                    'style' => 'text',
                ],
            ]
        );

        $repeater->add_control(
            'slider_style',
            [
                'label' => esc_html__( 'Layout Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => [
                    'slider' => esc_html__('Slider', 'boxcar'),
                    'text' => esc_html__('Input Text', 'boxcar'),
                ],
                'default' => 'slider',
                'condition' => [
                    'filter_field' => ['mileage', 'year'],
                ],
            ]
        );

        $repeater->add_control(
            'min_placeholder',
            [
                'label' => esc_html__( 'Min Placeholder', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Min',
                'condition' => [
                    'filter_field' => ['mileage', 'year'],
                    'slider_style' => 'text',
                ],
            ]
        );

        $repeater->add_control(
            'max_placeholder',
            [
                'label' => esc_html__( 'Max Placeholder', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Max',
                'condition' => [
                    'filter_field' => ['mileage', 'year'],
                    'slider_style' => 'text',
                ],
            ]
        );

        $repeater->add_control(
            'suffix',
            [
                'label' => esc_html__( 'Suffix', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Miles',
                'condition' => [
                    'filter_field' => ['mileage'],
                ],
            ]
        );

        $repeater->add_control(
            'filter_layout',
            [
                'label' => esc_html__( 'Filter Layout', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'select' => esc_html__('Select', 'boxcar'),
                    'radio' => esc_html__('Radio Button', 'boxcar'),
                    'check_list' => esc_html__('Check Box', 'boxcar'),
                ),
                'default' => 'select',
                'condition' => [
                    'filter_field' => ['category', 'condition', 'color', 'cylinder', 'door', 'drive_type', 'feature', 'fuel_type', 'make', 'model', 'offer_type', 'transmission', 'type'],
                ],
            ]
        );
        
        $columns = array();
        for ($i=1; $i <= 12 ; $i++) { 
            $columns[$i] = sprintf(esc_html__('%d Columns', 'boxcar'), $i);
        }
        $columns[20] = esc_html__('20%', 'boxcar');
        $repeater->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'default' => 1
            ]
        );

        $repeater->add_control(
            'selected_icon',
            [
                'label' => esc_html__( 'Icon', 'boxcar' ),
                'type' => Elementor\Controls_Manager::ICONS
            ]
        );

        $this->start_controls_section(
            'content_section_fields',
            [
                'label' => esc_html__( 'Search Form Fields', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'main_search_fields',
            [
                'label' => esc_html__( 'Main Search Fields', 'boxcar' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'show_advance_search',
            [
                'label'         => esc_html__( 'Show Advanced Search', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'advance_search_fields',
            [
                'label' => esc_html__( 'Advanced Search Fields', 'boxcar' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'filter_btn_text',
            [
                'label' => esc_html__( 'Button Text', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Find Listing',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'advanced_btn_text',
            [
                'label' => esc_html__( 'Advanced Text', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Advanced',
            ]
        );

        $this->add_control(
            'btn_columns',
            [
                'label' => esc_html__( 'Button Columns', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'default' => 1
            ]
        );

        $this->add_control(
            'show_button_search',
            [
                'label'         => esc_html__( 'Show Button Search', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );
        
        $this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout Type', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'horizontal' => esc_html__('Horizontal', 'boxcar'),
                    'vertical' => esc_html__('Vertical', 'boxcar'),
                ),
                'default' => 'horizontal',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'style_df' => esc_html__('Default', 'boxcar'),
                    'row_1' => esc_html__('1 Row', 'boxcar'),
                    'tabs-between' => esc_html__('Tabs Between', 'boxcar'),
                    'style_list' => esc_html__('List Items', 'boxcar'),
                ),
                'default' => 'style_df'
            ]
        );

        $this->add_control(
            'show_reset',
            [
                'label'         => esc_html__( 'Show Reset button', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'reset_save_search_columns',
            [
                'label' => esc_html__( 'Reset | Save Search Columns', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'default' => 1,
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_nav_style',
            [
                'label' => esc_html__( 'Tabs', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'tabs_nav_header_style' );

            $this->start_controls_tab(
                'tab_nav_normal',
                [
                    'label' => esc_html__( 'Normal', 'boxcar' ),
                ]
            );

            $this->add_control(
                'nav_color',
                [
                    'label' => esc_html__( 'Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tab-list span' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'nav_bg_color',
                [
                    'label' => esc_html__( 'Background Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tab-list span' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

            // tab hover
            $this->start_controls_tab(
                'tab_nav_hover',
                [
                    'label' => esc_html__( 'Hover', 'boxcar' ),
                ]
            );

            $this->add_control(
                'nav_color_hv',
                [
                    'label' => esc_html__( 'Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tabs-listing input:checked span' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'nav_bg_color_hv',
                [
                    'label' => esc_html__( 'Background Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tabs-listing input:checked span' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'nav_underline_color_hv',
                [
                    'label' => esc_html__( 'Under Line Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tab-list span::before' => 'background-color: {{VALUE}};',
                    ],
                ]
            );


            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'margin_tab',
            [
                'label' => esc_html__( 'Margin', 'boxcar' ),
                'type' => Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .tab-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__( 'Alignment', 'boxcar' ),
                'type' => Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => esc_html__( 'Left', 'boxcar' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'boxcar' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Right', 'boxcar' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tab-list' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_button_style',
            [
                'label' => esc_html__( 'Button', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'tabs_button_style' );

            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => esc_html__( 'Normal', 'boxcar' ),
                ]
            );
            
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .btn-submit' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'background_button',
                    'label' => esc_html__( 'Background', 'boxcar' ),
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .btn-submit',
                ]
            );

            $this->add_group_control(
                Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'border_button',
                    'label' => esc_html__( 'Border', 'boxcar' ),
                    'selector' => '{{WRAPPER}} .btn-submit',
                ]
            );

            $this->add_responsive_control(
                'padding_button',
                [
                    'label' => esc_html__( 'Padding', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .btn-submit' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'btn_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .btn-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Elementor\Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'box_shadow_button',
                    'label' => esc_html__( 'Box Shadow', 'boxcar' ),
                    'selector' => '{{WRAPPER}} .btn-submit',
                ]
            );

            $this->end_controls_tab();

            // tab hover
            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => esc_html__( 'Hover', 'boxcar' ),
                ]
            );

            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .btn-submit:hover, {{WRAPPER}} .btn-submit:focus' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'background_button_hover',
                    'label' => esc_html__( 'Background', 'boxcar' ),
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .btn-submit:hover, {{WRAPPER}} .btn-submit:focus',
                ]
            );

            $this->add_control(
                'button_hover_border_color',
                [
                    'label' => esc_html__( 'Border Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'condition' => [
                        'border_button_border!' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .btn-submit:hover, {{WRAPPER}} .btn-submit:focus' => 'border-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'padding_button_hover',
                [
                    'label' => esc_html__( 'Padding', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .btn-submit:hover, {{WRAPPER}} .btn-submit:focus' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'btn_hv_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .btn-submit:hover, {{WRAPPER}} .btn-submit:focus' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Elementor\Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'box_shadow_hv_button',
                    'label' => esc_html__( 'Box Shadow', 'boxcar' ),
                    'selector' => '{{WRAPPER}} .btn-submit:hover, {{WRAPPER}} .btn-submit:focus',
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();
        // end tab 

        $this->end_controls_section();


        $this->start_controls_section(
            'section_border_style',
            [
                'label' => esc_html__( 'Box', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'padding_box',
            [
                'label' => esc_html__( 'Padding', 'boxcar' ),
                'type' => Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} form.form-search .main-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bg_box',
            [
                'label' => esc_html__( 'Background Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} form.form-search .main-inner' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border_box',
                'label' => esc_html__( 'Border', 'boxcar' ),
                'selector' => '{{WRAPPER}} form.form-search .main-inner',
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'boxcar' ),
                'type' => Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} form.form-search .main-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'br_space_item',
            [
                'label' => esc_html__( 'Space Items Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} form.form-search .list-fileds > div' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_typography_style',
            [
                'label' => esc_html__( 'Typography', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'label_color',
            [
                'label' => esc_html__( 'Label Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading-label' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Label Typography', 'boxcar' ),
                'name' => 'label_typography',
                'selector' => '{{WRAPPER}} .heading-label',
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Text Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading-label' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .heading-label .price-text-wrapper' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .advance-search-btn' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .circle-check' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .form-control' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .form-control::-webkit-input-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .form-control:-ms-input-placeholder ' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .form-control::placeholder ' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .select2-selection--single' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .select2-selection--single .select2-selection__rendered' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .select2-selection--single .select2-selection__placeholder' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => esc_html__( 'Border Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .form-control' => 'border-color: {{VALUE}} !important;',
                    '{{WRAPPER}} .select2-container--default.select2-container .select2-selection--single' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'border_hv_color',
            [
                'label' => esc_html__( 'Border Active Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .form-control:focus' => 'border-color: {{VALUE}} !important;',
                    '{{WRAPPER}} .select2-container--default.select2-container.select2-container--open .select2-selection--single' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_advance_style',
            [
                'label' => esc_html__( 'Advance', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'tabs_advance_style' );

            $this->start_controls_tab(
                'tab_advance_normal',
                [
                    'label' => esc_html__( 'Normal', 'boxcar' ),
                ]
            );

            $this->add_control(
                'color_ad',
                [
                    'label' => esc_html__( 'Button Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .advance-search-btn' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

            // tab hover
            $this->start_controls_tab(
                'tab_advance_hover',
                [
                    'label' => esc_html__( 'Hover', 'boxcar' ),
                ]
            );

            $this->add_control(
                'color_ad_active',
                [
                    'label' => esc_html__( 'Button Active Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .advance-search-btn:hover,
                        {{WRAPPER}} .advance-search-btn:focus' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );
        
        $search_page_url = WP_CarDealer_Mixes::get_listings_page_url();

        boxcar_load_select2();

        $filter_fields = apply_filters( 'wp-cardealer-default-listing-filter-fields', array() );
        $instance = array();
        $widget_id = boxcar_random_key();
        $args = array( 'widget_id' => $widget_id );
        ?>
        <div class="widget-listing-search-form <?php echo esc_attr($el_class); ?>">
            
            <form id="filter-listing-form-<?php echo esc_attr($widget_id); ?>" action="<?php echo esc_url($search_page_url); ?>" class="form-search filter-listing-form <?php echo esc_attr($style.' '.$layout_type); ?>" method="GET">
                <div class="search-form-inner">

                    <?php if ( !empty($tabs_search) ) { ?>
                        <ul class="nav tab-list">
                            <?php foreach ($tabs_search as $tab) { ?>
                                <li>
                                    <label>
                                        <input type="radio" name="filter-condition" value="<?php echo esc_attr(isset($tab['tab_condition']) ? $tab['tab_condition'] : ''); ?>" <?php checked($active_tab, $tab['tab_condition'], true); ?>>
                                        <span>
                                            <?php
                                                if ( !empty($tab['tab_title']) ) {
                                                    echo esc_html($tab['tab_title']);
                                                }
                                            ?>
                                        </span>
                                    </label>
                                </li>
                            <?php } ?>
                        </ul>
                    <?php } ?>

                    <?php if ( $layout_type == 'horizontal' ) { ?>
                        <div class="main-inner clearfix">
                            <div class="content-main-inner">
                                <div class="row list-fileds d-lg-flex align-items-center row-10">
                                    <?php
                                        $this->form_fields_display($main_search_fields, $filter_fields, $instance, $args);
                                    ?>
                                    <div class="col-12 col-lg-<?php echo esc_attr($btn_columns); ?> form-group-search">
                                        <div class="d-flex align-items-center justify-content-xl-end">
                                            <?php if ( $show_advance_search && !empty($advance_search_fields) ) {
                                                $addvance_class = '';
                                                $href = 'javascript:void(0);';
                                            ?>
                                                <div class="advance-link">
                                                    <a href="<?php echo esc_url($href); ?>" class="advance-search-btn d-flex align-items-center <?php echo esc_attr($addvance_class); ?>">
                                                        <i class="flaticon-filter"></i>
                                                        <?php
                                                            if ( !empty($advanced_btn_text) ) {
                                                                echo esc_html($advanced_btn_text);
                                                            }
                                                        ?>
                                                    </a>
                                                </div>
                                            <?php } ?>
                                            <?php if ( $show_button_search ) { ?>
                                                <button class="btn-submit btn w-100 btn-theme <?php echo esc_attr( ($filter_btn_text)?'':'no-text' ); ?>" type="submit">
                                                    <i class="flaticon-search pre"></i><?php echo esc_html($filter_btn_text); ?>
                                                </button>
                                            <?php } ?>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <?php
                        if ( $show_advance_search && !empty($advance_search_fields) ) {
                            ?>
                            <div id="advance-search-wrapper-<?php echo esc_attr($widget_id); ?>" class="advance-search-wrapper">
                                <div class="advance-search-wrapper-fields">

                                    <div class="inner-search-advance">
                                        <div class="inner">
                                            <div class="row row-20">
                                                <?php
                                                    $this->form_fields_display($advance_search_fields, $filter_fields, $instance, $args);
                                                ?>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <?php
                        }
                        ?>
                    <?php } else { ?>
                        <div class="main-inner clearfix">
                            <div class="content-main-inner">
                                <div class="row">
                                    <?php
                                        $this->form_fields_display($main_search_fields, $filter_fields, $instance, $args);
                                    ?>

                                    <?php if( $show_advance_search && !empty($advance_search_fields)){
                                        $addvance_class = '';
                                        $href = 'javascript:void(0);';
                                    ?>
                                        <div class="col-12">
                                            <div class="form-group">
                                                <div class="advance-link">
                                                    <a href="<?php echo esc_url($href); ?>" class=" advance-search-btn d-flex align-items-center <?php echo esc_attr($addvance_class); ?>">
                                                        <i class="flaticon-filter"></i>
                                                        <?php
                                                            if ( !empty($advanced_btn_text) ) {
                                                                echo esc_html($advanced_btn_text);
                                                            }
                                                        ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>

                                </div>

                                <?php
                                if ( $show_advance_search && !empty($advance_search_fields) ) {
                                    ?>
                                    <div id="advance-search-wrapper-<?php echo esc_attr($widget_id); ?>" class="advance-search-wrapper">
                                        <div class="advance-search-wrapper-fields">

                                            <div class="inner-search-advance">
                                                <div class="inner">
                                                    <div class="row">
                                                        <?php
                                                            $this->form_fields_display($advance_search_fields, $filter_fields, $instance, $args);
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                                <?php if ( $show_button_search ) { ?>
                                    <div class="row">
                                        <div class="col-12 col-lg-<?php echo esc_attr($btn_columns); ?> form-group-search">
                                            <button class="btn-submit w-100 btn btn-theme <?php echo esc_attr( ($filter_btn_text)?'':'no-text' ); ?>" type="submit">
                                                <i class="flaticon-search pre"></i>
                                                <?php echo esc_html($filter_btn_text); ?>
                                            </button>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        
                        
                    <?php } ?>
                </div>
            </form>

        </div>
        <?php
    }

    public function form_fields_display($search_fields, $filter_fields, $instance, $args) {
        $i = 1;
        if ( !empty($search_fields) ) {
            $sub_class = '';
            foreach ($search_fields as $item) {
                if ( empty($filter_fields[$item['filter_field']]['field_call_back']) ) {
                    continue;
                }
                $filter_field = $filter_fields[$item['filter_field']];
                if ( $item['filter_field'] == 'title' ) {
                    if ($item['enable_autocompleate_search']) {
                        wp_enqueue_script( 'handlebars', get_template_directory_uri() . '/js/handlebars.min.js', array(), null, true);
                        wp_enqueue_script( 'typeahead-jquery', get_template_directory_uri() . '/js/typeahead.bundle.min.js', array('jquery', 'handlebars'), null, true);
                        $filter_field['add_class'] = 'apus-autocompleate-input';
                    }
                } elseif ( $item['filter_field'] == 'price' ) {
                    $filter_field['style'] = $item['style'];
                    $filter_field['min_price_placeholder'] = $item['min_price_placeholder'];
                    $filter_field['max_price_placeholder'] = $item['max_price_placeholder'];
                    $filter_field['price_range_size'] = $item['price_range_size'];
                    $filter_field['price_range_max'] = $item['price_range_max'];
                } elseif ( in_array($item['filter_field'], ['mileage', 'year']) ) {
                    $filter_field['slider_style'] = $item['slider_style'];
                    $filter_field['min_placeholder'] = $item['min_placeholder'];
                    $filter_field['max_placeholder'] = $item['max_placeholder'];
                }
                if ( in_array($item['filter_field'], ['mileage']) ) {
                    $filter_field['suffix'] = $item['suffix'];
                }
                if ( isset($item['selected_icon']) ) {
                    ob_start();
                    if ( empty( $item['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
                        // add old default
                        $item['icon'] = 'fa fa-star';
                    }
                    if ( ! empty( $item['icon'] ) ) {
                        $this->add_render_attribute( 'icon', 'class', $item['icon'] );
                        $this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
                    }
                    $migrated = isset( $item['__fa4_migrated']['selected_icon'] );
                    $is_new = empty( $item['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
                    if ( $is_new || $migrated ) {
                        Elementor\Icons_Manager::render_icon( $item['selected_icon'], [ 'aria-hidden' => 'true' ] );
                    } else { ?>
                        <i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
                    <?php }
                    $filter_field['icon_html'] = ob_get_clean();
                }
                if ( isset($item['placeholder']) ) {
                    $filter_field['placeholder'] = $item['placeholder'];
                }
                
                if ( !empty($item['title']) ) {
                    $filter_field['name'] = $item['title'];
                    $filter_field['show_title'] = true;
                } else {
                    $filter_field['show_title'] = false;
                }

                if ( $i == count($search_fields) ) {
                    $sub_class = 'last-modified';
                }

                if ( $item['filter_layout'] && in_array($item['filter_field'], array('category', 'condition', 'color', 'cylinder', 'door', 'drive_type', 'feature', 'fuel_type', 'make', 'model', 'offer_type', 'transmission', 'type')) ) {
                    switch ($item['filter_layout']) {
                        case 'radio':
                            $filter_field['field_call_back'] = array( 'WP_CarDealer_Abstract_Filter', 'filter_field_taxonomy_hierarchical_radio_list');
                            break;
                        case 'check_list':
                            $filter_field['field_call_back'] = array( 'WP_CarDealer_Abstract_Filter', 'filter_field_taxonomy_hierarchical_check_list');
                            break;
                        default:
                            if ( $item['filter_field'] == 'location' ) {
                                $filter_field['field_call_back'] = array( 'WP_CarDealer_Abstract_Filter', 'filter_field_location_select');
                            } else {
                                $filter_field['field_call_back'] = array( 'WP_CarDealer_Abstract_Filter', 'filter_field_taxonomy_hierarchical_select');
                            }
                            break;
                    }
                }
                
                $columns = !empty($item['columns']) ? $item['columns'] : '1';
                ?>
                <div class="col-12 col-lg-<?php echo esc_attr($columns); ?> <?php echo esc_attr($sub_class); ?>">
                    <?php call_user_func( $filter_field['field_call_back'], $instance, $args, $item['filter_field'], $filter_field ); ?>
                </div>
                <?php $i++;
            }
        }
    }
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_CarDealer_Search_Form_Tabs );
