<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_CarDealer_Mortgage_Calculator extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_cardealer_mortgage_calculator';
    }

	public function get_title() {
        return esc_html__( 'Apus Mortgage Calculator', 'boxcar' );
    }
    
	public function get_categories() {
        return [ 'boxcar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Mortgage Calculator', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => esc_html__( 'Enter your title here', 'boxcar' ),
            ]
        );

        $this->add_control(
            'des',
            [
                'label' => esc_html__( 'Description', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXTAREA,
                'input_type' => 'textarea',
                'placeholder' => esc_html__( 'Enter your description here', 'boxcar' ),
            ]
        );

        $this->add_control(
            'listing_price_title',
            [
                'label' => esc_html__( 'Listing Price', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Price ($)',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'listing_price',
            [
                'label' => esc_html__( 'Listing Price Default', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => '10000',
            ]
        );

        $this->add_control(
            'rate_title',
            [
                'label' => esc_html__( 'Interest Rate Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Interest Rate',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'rate',
            [
                'label' => esc_html__( 'Rate Default', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => '10',
            ]
        );

        $this->add_control(
            'year_title',
            [
                'label' => esc_html__( 'Loan Term Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Loan Term (year)',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'year',
            [
                'label' => esc_html__( 'Loan Term Default', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => '3',
            ]
        );

        $this->add_control(
            'deposit_title',
            [
                'label' => esc_html__( 'Down Payment Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Down Payment',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'deposit',
            [
                'label' => esc_html__( 'Down Payment Default', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => '5000',
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Calculate',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => esc_html__( 'Button Icon', 'boxcar' ),
                'type' => Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_control(
            'width_button',
            [
                'label' => esc_html__( 'Width Button', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Normal', 'boxcar'),
                    'w-100' => esc_html__('100%', 'boxcar'),
                ),
                'default' => ''
            ]
        );

        $this->add_control(
            'monthly_payment_text',
            [
                'label' => esc_html__( 'Monthly Payment Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Monthly Payment',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'total_interest_text',
            [
                'label' => esc_html__( 'Total Interest Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Total Interest',
            ]
        );

        $this->add_control(
            'total_payment_text',
            [
                'label' => esc_html__( 'Total Payment Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => 'Total Payment',
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Hidden', 'boxcar'),
                    'always_show' => esc_html__('Always Show Results', 'boxcar'),
                ),
                'default' => ''
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__( 'Style', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'results_color',
            [
                'label' => esc_html__( 'Results Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .apus_mortgage_results' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Results Typography', 'boxcar' ),
                'name' => 'results_typography',
                'selector' => '{{WRAPPER}} .apus_mortgage_results',
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        $current_currency = WP_CarDealer_Price::get_current_currency();
        $multi_currencies = WP_CarDealer_Price::get_currencies_settings();

        if ( !empty($multi_currencies) && !empty($multi_currencies[$current_currency]) ) {
            $currency_args = $multi_currencies[$current_currency];
        }

        if ( !empty($currency_args) ) {
            $currency_symbol = !empty($currency_args['custom_symbol']) ? $currency_args['custom_symbol'] : '';
            if ( empty($currency_symbol) ) {
                $currency = !empty($currency_args['currency']) ? $currency_args['currency'] : 'USD';
                $currency_symbol = WP_CarDealer_Price::currency_symbol($currency);
            }
        }

        if ( empty($currency_symbol) ) {
            $currency_symbol = '$';
        }
        ?>
        <div class="widget-mortgage-calculator <?php echo esc_attr($el_class); ?>">
            <div class="apus-mortgage-calculator <?php echo esc_attr($style); ?>">
                <div class="main-inner">
                    <div class="inner-info">
                        <?php if ( !empty($title) ) { ?>
                            <h4 class="title">
                                <?php echo esc_html($title); ?>
                            </h4>
                        <?php } ?>
                        <?php if ( !empty($des) ) { ?>
                            <div class="des">
                                <?php echo trim($des); ?>
                            </div>
                        <?php } ?>
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <div class="form-group">
                                    <label><?php echo esc_html($listing_price_title); ?></label>
                                    <input class="form-control" id="apus_mortgage_listing_price" placeholder="<?php echo esc_attr($listing_price); ?>" type="text" value="<?php echo esc_attr($listing_price); ?>">
                                </div>
                            </div>
                            
                            <div class="col-12 col-md-6">
                                <div class="form-group">
                                    <label><?php echo esc_html($rate_title); ?></label>
                                    <input class="form-control" id="apus_mortgage_interest_rate" type="text" placeholder="<?php echo esc_attr($rate); ?>" value="<?php echo esc_attr($rate); ?>">
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="form-group">
                                    <label><?php echo esc_html($year_title); ?></label>
                                    <input class="form-control" id="apus_mortgage_term_years" type="text" placeholder="<?php echo esc_attr($year); ?>" value="<?php echo esc_attr($year); ?>">
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="form-group">
                                    <label><?php echo esc_html($deposit_title); ?></label>
                                    <input class="form-control" id="apus_mortgage_deposit" type="text" placeholder="<?php echo esc_attr($deposit); ?>" value="<?php echo esc_attr($deposit); ?>">
                                </div>
                            </div>
                            <div class="col-12">
                                <button id="btn_mortgage_get_results" class="btn btn-theme <?php echo esc_attr($width_button); ?>">
                                    <?php echo esc_html($button_text); ?>
                                    <?php
                                    if ( empty( $settings['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
                                        // add old default
                                        $settings['icon'] = 'fa fa-star';
                                    }

                                    if ( ! empty( $settings['icon'] ) ) {
                                        $this->add_render_attribute( 'icon', 'class', $settings['icon'] );
                                        $this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
                                    }

                                    $migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
                                    $is_new = empty( $settings['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
                                    if ( $is_new || $migrated ) {
                                        Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                                    } else { ?>
                                        <i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
                                    <?php } ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="apus_mortgage_results">
                    <div class="monthly-payment">
                        <span class="text"><?php echo esc_html($monthly_payment_text); ?></span>
                        <span class="value"><?php echo WP_CarDealer_Price::format_price(0, true); ?></span>
                    </div>
                    <div class="total-interest">
                        <span class="text"><?php echo esc_html($total_interest_text); ?></span>
                        <span class="value"><?php echo WP_CarDealer_Price::format_price(0, true); ?></span>
                    </div>
                    <div class="total-payment">
                        <span class="text"><?php echo esc_html($total_payment_text); ?></span>
                        <span class="value"><?php echo WP_CarDealer_Price::format_price(0, true); ?></span>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_CarDealer_Mortgage_Calculator );
