<?php


if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_Login_Register_Form_Tabs extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_login_register_tabs';
    }

	public function get_title() {
        return esc_html__( 'Apus Login/Register Form Tabs', 'boxcar' );
    }
    
	public function get_categories() {
        return [ 'boxcar-header-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_login_form',
            [
                'label'         => esc_html__( 'Show Login Form', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );

        $this->add_control(
            'login_tab_title',
            [
                'label' => esc_html__( 'Login Tab Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'default' => 'Sign in',
                'condition' => [
                    'show_login_form' => true,
                ],
            ]
        );


        $this->add_control(
            'show_register_form',
            [
                'label'         => esc_html__( 'Show Register Form', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );

        $this->add_control(
            'register_tab_title',
            [
                'label' => esc_html__( 'Register Tab Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'default' => 'Register',
                'condition' => [
                    'show_register_form' => true,
                ],
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        if ( is_user_logged_in() ) {
            echo WP_CarDealer_Template_Loader::get_template_part( 'misc/loged-in' );
        } else {
            if ( $show_login_form || $show_register_form ) {
                $rand = boxcar_random_key();
        ?>
                <div class="login-register-form <?php echo esc_attr($el_class); ?>">

                   
                    <ul class="nav nav-tabs tabs-listing" role="tablist">
                        <?php if ( $show_login_form ) { ?>
                            <li><a class="active" data-bs-toggle="tab" href="#apus_login_form_<?php echo esc_attr($rand); ?>"><?php echo esc_html($login_tab_title); ?></a></li>
                        <?php } ?>

                        <?php if ( $show_register_form ) { ?>
                            <li><a class="<?php echo esc_attr($show_login_form ? '' : 'active'); ?>" data-bs-toggle="tab" href="#apus_register_form_<?php echo esc_attr($rand); ?>"><?php echo esc_html($register_tab_title); ?></a></li>
                        <?php } ?>
                    </ul>
                    
                    <div class="tab-content clearfix">
                        <?php if ( $show_login_form ) { ?>
                            <div class="tab-pane fade show active" id="apus_login_form_<?php echo esc_attr($rand); ?>">
                                <?php echo do_shortcode( '[wp_cardealer_login]' ); ?>
                            </div>
                        <?php } ?>
                        <?php if ( $show_register_form ) { ?>
                            <div class="tab-pane <?php echo esc_attr( !$show_login_form ? 'fade show active' : '' ); ?>" id="apus_register_form_<?php echo esc_attr($rand); ?>">
                                <?php echo do_shortcode( '[wp_cardealer_register]' ); ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            <?php }
        }
    }
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Login_Register_Form_Tabs );
