<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_CarDealer_Listing_Types extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_cardealer_listing_types';
    }

	public function get_title() {
        return esc_html__( 'Apus Listing Types', 'boxcar' );
    }
    
	public function get_categories() {
        return [ 'boxcar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Types Banner', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your title here', 'boxcar' ),
            ]
        );

        $repeater->add_control(
            'slug',
            [
                'label' => esc_html__( 'Type Slug', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your Type Slug here', 'boxcar' ),
            ]
        );

        $repeater->add_control(
            'custom_url',
            [
                'label' => esc_html__( 'Custom URL', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'url',
                'placeholder' => esc_html__( 'Enter your custom url here', 'boxcar' ),
            ]
        );

        $repeater->add_control(
            'type_icon',
            [
                'label' => esc_html__( 'Type Icon', 'boxcar' ),
                'type' => Elementor\Controls_Manager::ICONS,
            ]
        );

        $repeater->add_control(
            'img_bg_src',
            [
                'name' => 'image',
                'label' => esc_html__( 'Image', 'boxcar' ),
                'type' => Elementor\Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Here', 'boxcar' ),
            ]
        );

        $this->add_control(
            'types',
            [
                'label' => esc_html__( 'Types Box', 'boxcar' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default' => 'full',
                'separator' => 'none',
            ]
        );

        $this->add_control(
            'show_nb_listings',
            [
                'label' => esc_html__( 'Show Number Listings', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'boxcar' ),
                'label_off' => esc_html__( 'Show', 'boxcar' ),
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'style1' => esc_html__('Style 1', 'boxcar'),
                    'style2' => esc_html__('Style 2', 'boxcar'),
                    'style3' => esc_html__('Style 3', 'boxcar'),
                ),
                'default' => 'style1'
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid', 'boxcar'),
                    'carousel' => esc_html__('Carousel', 'boxcar'),
                    'list' => esc_html__('List', 'boxcar'),
                ),
                'default' => 'grid'
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 3,
            ]
        );

        $this->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__( 'Slides to Scroll', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'boxcar' ),
                'options' => $columns,
                'condition' => [
                    'columns!' => '1',
                    'layout_type' => 'carousel',
                ],
                'frontend_available' => true,
                'default' => 1,
            ]
        );

        $this->add_control(
            'rows',
            [
                'label' => esc_html__( 'Rows', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'number',
                'placeholder' => esc_html__( 'Enter your rows number here', 'boxcar' ),
                'default' => 1,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label'         => esc_html__( 'Show Navigation', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label'         => esc_html__( 'Show Pagination', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'slider_autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label'         => esc_html__( 'Infinite Loop', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_box',
            [
                'label' => esc_html__( 'Item Style', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'tabs_button_style' );

            $this->start_controls_tab(
                'tab_bg_normal',
                [
                    'label' => esc_html__( 'Normal', 'boxcar' ),
                ]
            );

            $this->add_group_control(
                Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'background_box',
                    'selector' => '{{WRAPPER}} .type-banner-inner, {{WRAPPER}} .list-type-banner',
                ]
            );

            $this->add_group_control(
                Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'border_box',
                    'label' => esc_html__( 'Border', 'boxcar' ),
                    'selector' => '{{WRAPPER}} .type-banner-inner, {{WRAPPER}} .list-type-banner',
                ]
            );


            $this->end_controls_tab();

            // tab hover
            $this->start_controls_tab(
                'tab_bg_hover',
                [
                    'label' => esc_html__( 'Hover', 'boxcar' ),
                ]
            );

            $this->add_group_control(
                Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'background_hv_box',
                    'selector' => '{{WRAPPER}} .type-banner-inner:hover, {{WRAPPER}} .list-type-banner:hover',
                ]
            );

            $this->add_control(
                'border_box_hover',
                [
                    'label' => esc_html__( 'Border Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'condition' => [
                        'border_box_border!' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .type-banner-inner:hover, {{WRAPPER}} .list-type-banner:hover' => 'border-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'padding_box',
            [
                'label' => esc_html__( 'Padding', 'boxcar' ),
                'type' => Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .type-banner-inner, {{WRAPPER}} .list-type-banner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'radius_box',
            [
                'label' => esc_html__( 'Border Radius', 'boxcar' ),
                'type' => Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .type-banner-inner, {{WRAPPER}} .list-type-banner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Information', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'tabs_info_style' );

            $this->start_controls_tab(
                'tab_info_normal',
                [
                    'label' => esc_html__( 'Normal', 'boxcar' ),
                ]
            );

            $this->add_control(
                'icon_color',
                [
                    'label' => esc_html__( 'Icon Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .type-icon' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'icon_bg_color',
                [
                    'label' => esc_html__( 'Icon Background Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .type-icon' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'number_color',
                [
                    'label' => esc_html__( 'Number Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .number' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

            // tab hover
            $this->start_controls_tab(
                'tab_info_hover',
                [
                    'label' => esc_html__( 'Hover', 'boxcar' ),
                ]
            );

            $this->add_control(
                'icon_hv_color',
                [
                    'label' => esc_html__( 'Icon Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .type-banner-inner:hover .type-icon, {{WRAPPER}} .list-type-banner:hover .type-icon' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'icon_hv_bg_color',
                [
                    'label' => esc_html__( 'Icon Background Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .type-banner-inner:hover .type-icon, {{WRAPPER}} .list-type-banner:hover .type-icon' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'title_hv_color',
                [
                    'label' => esc_html__( 'Title Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .type-banner-inner:hover .title, {{WRAPPER}} .list-type-banner:hover .title' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_control(
                'number_hv_color',
                [
                    'label' => esc_html__( 'Number Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .type-banner-inner:hover .number, {{WRAPPER}} .list-type-banner:hover .number' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Icon Typography', 'boxcar' ),
                'name' => 'icon_typography',
                'selector' => '{{WRAPPER}} .type-icon',
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Title Typography', 'boxcar' ),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .title',
            ]
        );
        
        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Number Typography', 'boxcar' ),
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} .number',
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        if ( !empty($types) ) {
            if ( $image_size == 'custom' ) {
                
                if ( $image_custom_dimension['width'] && $image_custom_dimension['height'] ) {
                    $thumbsize = $image_custom_dimension['width'].'x'.$image_custom_dimension['height'];
                } else {
                    $thumbsize = 'full';
                }
            } else {
                $thumbsize = $image_size;
            }

            $columns = !empty($columns) ? $columns : 3;
            $columns_tablet = !empty($columns_tablet) ? $columns_tablet : 2;
            $columns_mobile = !empty($columns_mobile) ? $columns_mobile : 1;
            
            $slides_to_scroll = !empty($slides_to_scroll) ? $slides_to_scroll : 1;
            $slides_to_scroll_tablet = !empty($slides_to_scroll_tablet) ? $slides_to_scroll_tablet : $columns_tablet;
            $slides_to_scroll_mobile = !empty($slides_to_scroll_mobile) ? $slides_to_scroll_mobile : $columns_mobile;
        ?>
            <div class="widget-listing-types <?php echo esc_attr($el_class); ?>">
                <?php if ( $layout_type == 'carousel' ) {
                    
                    $slides_to_scroll = !empty($slides_to_scroll) ? $slides_to_scroll : $columns;
                    $slides_to_scroll_tablet = !empty($slides_to_scroll_tablet) ? $slides_to_scroll_tablet : $slides_to_scroll;
                    $slides_to_scroll_mobile = !empty($slides_to_scroll_mobile) ? $slides_to_scroll_mobile : 1;
                ?>
                    <div class="slick-carousel <?php echo ( ( $columns >= 8)?'gap-20':'' ); ?> <?php echo ( ( $columns >= count($types))?'hidden-dots':'' ); ?>"
                        data-items="<?php echo esc_attr($columns); ?>"
                        data-large="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-medium="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-small="<?php echo esc_attr($columns_mobile); ?>"
                        data-smallest="<?php echo esc_attr($columns_mobile); ?>"

                        data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                        data-slidestoscroll_large="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_medium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_small="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-slidestoscroll_smallest="<?php echo esc_attr($slides_to_scroll_mobile); ?>"

                        data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>">

                        <?php foreach ($types as $item) {
                            $term = get_term_by( 'slug', $item['slug'], 'listing_type' );
                            $link = $item['custom_url'];
                            $title = $item['title'];
                            if ($term) {
                                if ( empty($link) ) {
                                    $link = get_term_link( $term, 'listing_type' );
                                }
                                if ( empty($title) ) {
                                    $title = $term->name;
                                }
                            }

                            $has_img = (!empty($item['img_bg_src']['id']))?' has-img':'';
                            ?>
                            <div class="item">
                                <a class="d-block type-banner-inner <?php echo esc_attr($style.$has_img); ?>" href="<?php echo esc_url($link); ?>">
                                    <?php
                                    if ( !empty($item['img_bg_src']['id']) ) {
                                    ?>
                                        <div class="banner-image d-flex justify-content-center">
                                            <?php echo boxcar_get_attachment_thumbnail($item['img_bg_src']['id'], $thumbsize); ?>
                                        </div>
                                    <?php } ?>
                                    <div class="inner">
                                            <?php if ( !empty($item['type_icon']['value']) || !empty($item['type_icon']['library']) ) { ?>
                                                <div class="type-icon d-flex align-items-center justify-content-center">
                                                    <?php
                                                    if ( empty( $item['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
                                                        // add old default
                                                        $item['icon'] = 'fa fa-star';
                                                    }

                                                    if ( ! empty( $item['icon'] ) ) {
                                                        $this->add_render_attribute( 'icon', 'class', $item['icon'] );
                                                        $this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
                                                    }

                                                    $migrated = isset( $item['__fa4_migrated']['type_icon'] );
                                                    $is_new = empty( $item['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
                                                    if ( $is_new || $migrated ) {
                                                        Elementor\Icons_Manager::render_icon( $item['type_icon'], [ 'aria-hidden' => 'true' ] );
                                                    } else { ?>
                                                        <i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
                                                    <?php } ?>
                                                </div>
                                            <?php } ?>
                                            
                                            <?php if ( $show_nb_listings ) {
                                                    $args = array(
                                                        'fields' => 'ids',
                                                        'type' => array($item['slug']),
                                                        'limit' => 1
                                                    );
                                                    $query = boxcar_get_listings($args);
                                                    $count = $query->found_posts;
                                                    $number_listings = $count ? WP_CarDealer_Mixes::format_number($count) : 0;
                                            ?>
                                            <div class="number"><?php echo sprintf(_n('<span>%d</span> Car', '<span>%d</span> Cars', $count, 'boxcar'), $number_listings); ?></div>
                                            <?php } ?>
                                            <?php if ( !empty($title) ) { ?>
                                                <h4 class="title">
                                                    <?php echo esc_html($title); ?>
                                                </h4>
                                            <?php } ?>
                                        </div>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                <?php } elseif($layout_type == 'grid') { ?>
                    <div class="row <?php echo ( ( $columns >= 8)?'row-20':'' ); ?>">
                        <?php
                            $mdcol = 12/$columns;
                            $smcol = 12/$columns_tablet;
                            $xscol = 12/$columns_mobile;
                        ?>
                        <?php foreach ($types as $item) {
                            $term = get_term_by( 'slug', $item['slug'], 'listing_type' );
                            $link = $item['custom_url'];
                            $title = $item['title'];
                            if ($term) {
                                if ( empty($link) ) {
                                    $link = get_term_link( $term, 'listing_type' );
                                }
                                if ( empty($title) ) {
                                    $title = $term->name;
                                }
                            }
                            $has_img = (!empty($item['img_bg_src']['id']))?' has-img':'';
                            ?>
                            <div class="col-xl-<?php echo esc_attr($mdcol); ?> col-md-<?php echo esc_attr($smcol); ?> col-<?php echo esc_attr( $xscol ); ?> list-item">
                                <a class="d-block type-banner-inner <?php echo esc_attr($style.$has_img); ?>" href="<?php echo esc_url($link); ?>">
                                    <?php
                                    if ( !empty($item['img_bg_src']['id']) ) {
                                    ?>
                                        <div class="banner-image d-flex justify-content-center">
                                            <?php echo boxcar_get_attachment_thumbnail($item['img_bg_src']['id'], $thumbsize); ?>
                                        </div>
                                    <?php } ?>
                                    <div class="inner">
                                            <?php if ( !empty($item['type_icon']['value']) || !empty($item['type_icon']['library']) ) { ?>
                                                <div class="type-icon d-flex align-items-center justify-content-center">
                                                    <?php
                                                    if ( empty( $item['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
                                                        // add old default
                                                        $item['icon'] = 'fa fa-star';
                                                    }

                                                    if ( ! empty( $item['icon'] ) ) {
                                                        $this->add_render_attribute( 'icon', 'class', $item['icon'] );
                                                        $this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
                                                    }

                                                    $migrated = isset( $item['__fa4_migrated']['type_icon'] );
                                                    $is_new = empty( $item['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
                                                    if ( $is_new || $migrated ) {
                                                        Elementor\Icons_Manager::render_icon( $item['type_icon'], [ 'aria-hidden' => 'true' ] );
                                                    } else { ?>
                                                        <i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
                                                    <?php } ?>
                                                </div>
                                            <?php } ?>
                                            
                                            
                                            <?php if ( $show_nb_listings ) {
                                                    $args = array(
                                                        'fields' => 'ids',
                                                        'type' => array($item['slug']),
                                                        'limit' => 1
                                                    );
                                                    $query = boxcar_get_listings($args);
                                                    $count = $query->found_posts;
                                                    $number_listings = $count ? WP_CarDealer_Mixes::format_number($count) : 0;
                                            ?>
                                            <div class="number"><?php echo sprintf(_n('<span>%d</span> Car', '<span>%d</span> Cars', $count, 'boxcar'), $number_listings); ?></div>
                                            <?php } ?>
                                            <?php if ( !empty($title) ) { ?>
                                                <h4 class="title">
                                                    <?php echo esc_html($title); ?>
                                                </h4>
                                            <?php } ?>
                                    </div>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                <?php } else { ?>
                    <div class="d-flex flex-wrap">
                        <?php foreach ($types as $item) {
                            $term = get_term_by( 'slug', $item['slug'], 'listing_type' );
                            $link = $item['custom_url'];
                            $title = $item['title'];
                            if ($term) {
                                if ( empty($link) ) {
                                    $link = get_term_link( $term, 'listing_type' );
                                }
                                if ( empty($title) ) {
                                    $title = $term->name;
                                }
                            }
                            ?>
                                <a class="list-type-banner d-inline-flex align-items-center" href="<?php echo esc_url($link); ?>">
                                    <?php if ( !empty($item['type_icon']['value']) || !empty($item['type_icon']['library']) ) { ?>
                                        <div class="type-icon">
                                            <?php
                                            if ( empty( $item['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
                                                // add old default
                                                $item['icon'] = 'fa fa-star';
                                            }

                                            if ( ! empty( $item['icon'] ) ) {
                                                $this->add_render_attribute( 'icon', 'class', $item['icon'] );
                                                $this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
                                            }

                                            $migrated = isset( $item['__fa4_migrated']['type_icon'] );
                                            $is_new = empty( $item['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
                                            if ( $is_new || $migrated ) {
                                                Elementor\Icons_Manager::render_icon( $item['type_icon'], [ 'aria-hidden' => 'true' ] );
                                            } else { ?>
                                                <i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
                                            <?php } ?>
                                        </div>
                                    <?php } ?>
                                    <div class="inner">
                                        <?php if ( !empty($title) ) { ?>
                                            <h4 class="title">
                                                <?php echo esc_html($title); ?>
                                            </h4>
                                        <?php } ?>
                                        <?php if ( $show_nb_listings ) {
                                                $args = array(
                                                    'fields' => 'ids',
                                                    'type' => array($item['slug']),
                                                    'limit' => 1
                                                );
                                                $query = boxcar_get_listings($args);
                                                $count = $query->found_posts;
                                                $number_listings = $count ? WP_CarDealer_Mixes::format_number($count) : 0;
                                        ?>
                                        <div class="number"><?php echo sprintf(_n('<span>%d</span> Car', '<span>%d</span> Cars', $count, 'boxcar'), $number_listings); ?></div>
                                        <?php } ?>
                                    </div>
                                </a>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        <?php
        }
    }
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_CarDealer_Listing_Types );
