<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_CarDealer_Listings_Tabs extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_cardealer_listings_tabs';
    }

	public function get_title() {
        return esc_html__( 'Apus Listings Tabs', 'boxcar' );
    }
    
	public function get_categories() {
        return [ 'boxcar-elements' ];
    }

    public function get_tax_keys() {
        return array('type', 'category', 'condition', 'make', 'model');
    }

	protected function register_controls() {
        $meta_obj = WP_CarDealer_Listing_Meta::get_instance(0);

        $fields = $meta_obj->get_metas();
        
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Listings', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__( 'Tab Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT
            ]
        );

        $tax_keys = $this->get_tax_keys();
        foreach( $tax_keys as $tax_key ) {
            if ( $meta_obj->check_post_meta_exist($tax_key) ) {
                $repeater->add_control(
                    $tax_key.'_slugs',
                    [
                        'label' => sprintf(esc_html__( '%s Slug', 'boxcar' ), $fields[WP_CARDEALER_LISTING_PREFIX.$tax_key]['name']),
                        'type' => Elementor\Controls_Manager::TEXTAREA,
                        'rows' => 1,
                        'default' => '',
                        'placeholder' => esc_html__( 'Enter slugs spearate by comma(,)', 'boxcar' ),
                    ]
                );
            }
        }

        $repeater->add_control(
            'orderby',
            [
                'label' => esc_html__( 'Order by', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'boxcar'),
                    'date' => esc_html__('Date', 'boxcar'),
                    'ID' => esc_html__('ID', 'boxcar'),
                    'author' => esc_html__('Author', 'boxcar'),
                    'title' => esc_html__('Title', 'boxcar'),
                    'modified' => esc_html__('Modified', 'boxcar'),
                    'rand' => esc_html__('Random', 'boxcar'),
                    'comment_count' => esc_html__('Comment count', 'boxcar'),
                    'menu_order' => esc_html__('Menu order', 'boxcar'),
                ),
                'default' => ''
            ]
        );

        $repeater->add_control(
            'order',
            [
                'label' => esc_html__( 'Sort order', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'boxcar'),
                    'ASC' => esc_html__('Ascending', 'boxcar'),
                    'DESC' => esc_html__('Descending', 'boxcar'),
                ),
                'default' => ''
            ]
        );

        $repeater->add_control(
            'get_listings_by',
            [
                'label' => esc_html__( 'Get Listings By', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => '',
                    'featured' => esc_html__('Featured Listings', 'boxcar'),
                    'popular' => esc_html__('Popular Listings', 'boxcar'),
                    'recent' => esc_html__('Recent Listings', 'boxcar'),
                ),
                'default' => 'recent'
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Tabs', 'boxcar' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'placeholder' => esc_html__( 'Enter your listing tabs here', 'boxcar' ),
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'limit',
            [
                'label' => esc_html__( 'Limit', 'boxcar' ),
                'type' => Elementor\Controls_Manager::NUMBER,
                'input_type' => 'number',
                'description' => esc_html__( 'Limit listings to display', 'boxcar' ),
                'default' => 4
            ]
        );
        
        $this->add_control(
            'listing_item_style',
            [
                'label' => esc_html__( 'Listing Item Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid Default', 'boxcar'),
                    'grid-v1' => esc_html__('Grid V1', 'boxcar'),
                    'grid-v2' => esc_html__('Grid V2', 'boxcar'),
                    'grid-v3' => esc_html__('Grid V3', 'boxcar'),
                    'grid-v4' => esc_html__('Grid V4', 'boxcar'),
                    'grid-v5' => esc_html__('Grid V5', 'boxcar'),
                    'list' => esc_html__('List Default', 'boxcar'),
                    'list-v1' => esc_html__('List v1', 'boxcar'),
                    'list-v2' => esc_html__('List v2', 'boxcar'),
                    'list-v3' => esc_html__('List v3', 'boxcar'),
                ),
                'default' => 'grid'
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid', 'boxcar'),
                    'carousel' => esc_html__('Carousel', 'boxcar'),
                ),
                'default' => 'grid'
            ]
        );


        $this->add_control(
            'fullscreen',
            [
                'label'         => esc_html__( 'Full Screen', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 3,
            ]
        );

        $this->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__( 'Slides to Scroll', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'boxcar' ),
                'options' => $columns,
                'condition' => [
                    'columns!' => '1',
                    'layout_type' => 'carousel',
                ],
                'frontend_available' => true,
                'default' => 3,
            ]
        );

        $this->add_control(
            'rows',
            [
                'label' => esc_html__( 'Rows', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'number',
                'placeholder' => esc_html__( 'Enter your rows number here', 'boxcar' ),
                'default' => 1,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label'         => esc_html__( 'Show Navigation', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label'         => esc_html__( 'Show Pagination', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'slider_autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label'         => esc_html__( 'Infinite Loop', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'position_nav',
            [
                'label' => esc_html__( 'Position Nav', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'boxcar'),
                    'nav-bottom' => esc_html__('Bottom', 'boxcar'),
                    'nav-center-bottom' => esc_html__('Center Bottom', 'boxcar'),
                ),
                'default' => '',
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Tabs', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__( 'Alignment', 'boxcar' ),
                'type' => Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => esc_html__( 'Left', 'boxcar' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'boxcar' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Right', 'boxcar' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tabs-listing' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'tabs_button_header_style' );

            $this->start_controls_tab(
                'tab_title_normal',
                [
                    'label' => esc_html__( 'Normal', 'boxcar' ),
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tabs-listing a' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'title_bg_color',
                [
                    'label' => esc_html__( 'Background Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tabs-listing a' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

            // tab hover
            $this->start_controls_tab(
                'tab_title_hover',
                [
                    'label' => esc_html__( 'Hover', 'boxcar' ),
                ]
            );

            $this->add_control(
                'title_color_hv',
                [
                    'label' => esc_html__( 'Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tabs-listing a:hover, {{WRAPPER}} .tabs-listing a:focus, {{WRAPPER}} .tabs-listing a.active' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'title_bg_color_hv',
                [
                    'label' => esc_html__( 'Background Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tabs-listing a:hover, {{WRAPPER}} .tabs-listing a:focus, {{WRAPPER}} .tabs-listing a.active' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'title_underline_color_hv',
                [
                    'label' => esc_html__( 'Background Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .tabs-listing a::before' => 'background-color: {{VALUE}};',
                    ],
                ]
            );


            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'section_nav_style',
            [
                'label' => esc_html__( 'Navigation', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border_nav',
                'label' => esc_html__( 'Border', 'boxcar' ),
                'selector' => '{{WRAPPER}} .tabs-listing',
            ]
        );

        $this->start_controls_tabs( 'tabs_nav_style' );

            $this->start_controls_tab(
                'tab_nav_normal',
                [
                    'label' => esc_html__( 'Normal', 'boxcar' ),
                ]
            );

            $this->add_control(
                'nav_color',
                [
                    'label' => esc_html__( 'Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .slick-carousel .slick-arrow' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'nav_bg_color',
                [
                    'label' => esc_html__( 'Background Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .slick-carousel .slick-arrow' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'nav_br_color',
                [
                    'label' => esc_html__( 'Border Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .slick-carousel .slick-arrow' => 'border-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

            // tab hover
            $this->start_controls_tab(
                'tab_nav_hover',
                [
                    'label' => esc_html__( 'Hover', 'boxcar' ),
                ]
            );

            $this->add_control(
                'nav_color_hv',
                [
                    'label' => esc_html__( 'Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .slick-carousel .slick-arrow:hover, {{WRAPPER}} .slick-carousel .slick-arrow:focus, {{WRAPPER}} .slick-carousel .slick-arrow.active' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'nav_bg_color_hv',
                [
                    'label' => esc_html__( 'Background Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .slick-carousel .slick-arrow:hover, {{WRAPPER}} .slick-carousel .slick-arrow:focus, {{WRAPPER}} .slick-carousel .slick-arrow.active' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'nav_br_color_hv',
                [
                    'label' => esc_html__( 'Border Color', 'boxcar' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .slick-carousel .slick-arrow:hover, {{WRAPPER}} .slick-carousel .slick-arrow:focus, {{WRAPPER}} .slick-carousel .slick-arrow.active' => 'border-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();


        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );
        $_id = boxcar_random_key();
        ?>
        <div class="widget-listings-tabs <?php echo esc_attr($layout_type); ?> <?php echo esc_attr($el_class); ?>">
            
            <ul role="tablist" class="nav nav-tabs tabs-listing">
                <?php $tab_count = 0; foreach ($tabs as $tab) : ?>
                    <li>
                        <a href="#tab-<?php echo esc_attr($_id);?>-<?php echo esc_attr($tab_count); ?>" data-bs-toggle="tab" class="<?php echo esc_attr($tab_count == 0 ? 'active' : '');?>">
                            <?php if ( !empty($tab['title']) ) { ?>
                                <?php echo esc_html($tab['title']); ?>
                            <?php } ?>
                        </a>
                    </li>
                <?php $tab_count++; endforeach; ?>
            </ul>

            <div class="tab-content">
                <?php
                    $columns = !empty($columns) ? $columns : 3;
                    $columns_tablet = !empty($columns_tablet) ? $columns_tablet : 2;
                    $columns_mobile = !empty($columns_mobile) ? $columns_mobile : 1;
                    
                    $slides_to_scroll = !empty($slides_to_scroll) ? $slides_to_scroll : 1;
                    $slides_to_scroll_tablet = !empty($slides_to_scroll_tablet) ? $slides_to_scroll_tablet : $columns_tablet;
                    $slides_to_scroll_mobile = !empty($slides_to_scroll_mobile) ? $slides_to_scroll_mobile : $columns_mobile;

                    $tab_count = 0; foreach ($tabs as $tab) : ?>
                    <div id="tab-<?php echo esc_attr($_id);?>-<?php echo esc_attr($tab_count); ?>" class="tab-pane <?php echo esc_attr($tab_count == 0 ? 'active' : ''); ?>">
                        <?php

                        $args = array(
                            'limit' => $limit,
                            'get_listings_by' => !empty($tab['get_listings_by']) ? $tab['get_listings_by'] : 'recent',
                            'orderby' => !empty($tab['orderby']) ? $tab['orderby'] : '',
                            'order' => !empty($tab['order']) ? $tab['order'] : ''
                        );

                        $tax_keys = $this->get_tax_keys();
                        foreach( $tax_keys as $tax_key ) {
                            $args[$tax_key] = !empty($tab[$tax_key.'_slugs']) ? array_map('trim', explode(',', $tab[$tax_key.'_slugs'])) : array();
                        }
                        
                        $loop = boxcar_get_listings($args);
                        if ( $loop->have_posts() ) {
                            ?>
                            <?php if ( $layout_type == 'carousel' ): ?>
                                <div class="slick-carousel <?php echo esc_attr($columns < $loop->post_count?'':'hidden-dots'); ?> <?php echo esc_attr( $fullscreen ? 'fullscreen' : 'nofullscreen' ); ?> <?php echo esc_attr($position_nav); ?>"
                                    
                                    data-items="<?php echo esc_attr($columns); ?>"
                                    data-large="<?php echo esc_attr( $columns_tablet ); ?>"
                                    data-medium="<?php echo esc_attr( $columns_tablet ); ?>"
                                    data-small="<?php echo esc_attr($columns_mobile); ?>"
                                    data-smallest="<?php echo esc_attr($columns_mobile); ?>"

                                    data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                                    data-slidestoscroll_large="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                                    data-slidestoscroll_medium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                                    data-slidestoscroll_small="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                                    data-slidestoscroll_smallest="<?php echo esc_attr($slides_to_scroll_mobile); ?>"

                                    data-pagination="<?php echo esc_attr( $show_pagination ? 'true' : 'false' ); ?>" data-nav="<?php echo esc_attr( $show_nav ? 'true' : 'false' ); ?>" data-rows="<?php echo esc_attr( $rows ); ?>" data-infinite="<?php echo esc_attr( $infinite_loop ? 'true' : 'false' ); ?>" data-autoplay="<?php echo esc_attr( $slider_autoplay ? 'true' : 'false' ); ?>">
                                    <?php while ( $loop->have_posts() ): $loop->the_post(); ?>
                                        <div class="cl-inner">
                                            <?php echo WP_CarDealer_Template_Loader::get_template_part( 'template-listings/listings-styles/inner-'.$listing_item_style ); ?>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            <?php else: ?>
                                <?php
                                    $mdcol = 12/$columns;
                                    $smcol = 12/$columns_tablet;
                                    $xscol = 12/$columns_mobile;
                                ?>
                                <div class="row">
                                    <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                                        <div class="col-xl-<?php echo esc_attr($mdcol); ?> col-md-<?php echo esc_attr($smcol); ?> col-<?php echo esc_attr( $xscol ); ?>">
                                            <?php echo WP_CarDealer_Template_Loader::get_template_part( 'template-listings/listings-styles/inner-'.$listing_item_style ); ?>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            <?php endif; ?>
                            <?php wp_reset_postdata(); ?>
                        <?php } ?>
                    </div>
                <?php $tab_count++; endforeach; ?>
            </div>
        </div>
        <?php
    }
}


Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_CarDealer_Listings_Tabs );
