<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_CarDealer_Listings_Slider extends Elementor\Widget_Base {

    public function get_name() {
        return 'apus_element_cardealer_listings_slider';
    }

    public function get_title() {
        return esc_html__( 'Apus Listings Slider', 'boxcar' );
    }
    
    public function get_categories() {
        return [ 'boxcar-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Listings', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'listing_id', [
                'label' => esc_html__( 'Listing ID', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter listing ID', 'boxcar' ),
            ]
        );

        $repeater->add_control(
            'image',
            [
                'name' => 'image',
                'label' => esc_html__( 'Image Background', 'boxcar' ),
                'type' => Elementor\Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Background Here', 'boxcar' ),
            ]
        );

        $this->add_control(
            'sliders',
            [
                'label' => esc_html__( 'Sliders', 'boxcar' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'placeholder' => esc_html__( 'Enter your listing tabs here', 'boxcar' ),
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label' => esc_html__( 'Height', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SLIDER,
                'default' => [
                    'size' => 235,
                ],
                'range' => [
                    'px' => [
                        'min' => 235,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .listing-grid-slider-wrapper' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label'         => esc_html__( 'Show Navigation', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label'         => esc_html__( 'Show Pagination', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label'         => esc_html__( 'Infinite Loop', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Style 1', 'boxcar'),
                    'st2' => esc_html__('Style 2', 'boxcar'),
                ),
                'default' => ''
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        if ( !empty($sliders) ) {
        ?>
        <div class="widget-listings-slider <?php echo esc_attr($el_class); ?>">
            <?php if($style != "st2") { ?>
                <div class="slick-carousel slick-carousel-slider no-gap" data-items="1" data-large="1" data-medium="1" data-small="1" data-smallest="1" data-pagination="<?php echo esc_attr( $show_pagination ? 'true' : 'false' ); ?>" data-nav="<?php echo esc_attr( $show_nav ? 'true' : 'false' ); ?>" data-infinite="<?php echo esc_attr( $infinite_loop ? 'true' : 'false' ); ?>" data-autoplay="<?php echo esc_attr( $autoplay ? 'true' : 'false' ); ?>">
                    <?php foreach ($sliders as $slider): ?>
                        <div class="item position-relative">
                            <?php 
                                $img_bg_src = ( isset( $slider['image']['id'] ) && $slider['image']['id'] != 0 ) ? wp_get_attachment_url( $slider['image']['id'] ) : '';
                                $style_bg = '';
                                if ( !empty($img_bg_src) ) {
                                    $style_bg = 'style="background-image:url('.esc_url($img_bg_src).')"';
                                }
                            ?>
                            <div class="listing-grid-slider-wrapper d-flex flex-column justify-content-center" <?php echo trim($style_bg); ?>>
                                <div class="max-width-1430">
                                    <?php
                                    if ( !empty($slider['listing_id']) ) {

                                        $post_object = get_post( $slider['listing_id'] );
                                        if ( $post_object ) {
                                            setup_postdata( $GLOBALS['post'] =& $post_object );
                                            global $post;
                                            ?>
                                                <div class="listing-grid-slider">

                                                    <?php boxcar_listing_display_price($post); ?>

                                                    <?php the_title( sprintf( '<h2 class="listing-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
                                                    
                                                    <?php
                                                    $meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
                                                    $unit = wp_cardealer_get_option('search_distance_unit', 'miles');
                                                    if ( $unit == 'miles' ) {
                                                        $unit = esc_html__('Miles', 'boxcar');
                                                    } elseif( $unit == 'km' ) {
                                                        $unit = esc_html__('Km', 'boxcar');
                                                    }
                                                    $mileage = boxcar_listing_display_meta($post, 'mileage', 'flaticon-speedometer', false, $unit);
                                                    $fuel_type = boxcar_listing_display_tax_without_url($post, 'fuel_type', 'flaticon-gasoline-pump', false, false );
                                                    $transmission = boxcar_listing_display_tax_without_url($post, 'transmission', 'flaticon-gearbox', false, false );

                                                    if ( $mileage || $transmission || $fuel_type ) {
                                                    ?>
                                                        <div class="listing-metas d-flex align-items-center flex-wrap">
                                                            <?php
                                                                echo trim($fuel_type);
                                                                echo trim($mileage);
                                                                echo trim($transmission);
                                                            ?>
                                                        </div>
                                                    <?php } ?>
                                                    <div class="more-link">
                                                    <a class="btn btn-white" href="<?php the_permalink(); ?>"><?php echo esc_html__('Learn More','boxcar'); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
                    <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
                    </svg></a></div>
                                                </div>

                                            <?php

                                            wp_reset_postdata();
                                        }

                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php } else { ?>
                <div class="slick-carousel slick-carousel-slider-v2 no-gap" data-items="1" data-large="1" data-medium="1" data-small="1" data-smallest="1" data-pagination="<?php echo esc_attr( $show_pagination ? 'true' : 'false' ); ?>" data-nav="<?php echo esc_attr( $show_nav ? 'true' : 'false' ); ?>" data-infinite="<?php echo esc_attr( $infinite_loop ? 'true' : 'false' ); ?>" data-autoplay="<?php echo esc_attr( $autoplay ? 'true' : 'false' ); ?>">
                    <?php foreach ($sliders as $slider): ?>
                        <div class="item position-relative">
                            <?php 
                                $img_bg_src = ( isset( $slider['image']['id'] ) && $slider['image']['id'] != 0 ) ? wp_get_attachment_url( $slider['image']['id'] ) : '';
                                $style_bg = '';
                                if ( !empty($img_bg_src) ) {
                                    $style_bg = 'style="background-image:url('.esc_url($img_bg_src).')"';
                                }
                            ?>
                            <?php
                            if ( !empty($slider['listing_id']) ) {
                                $post_object = get_post( $slider['listing_id'] );
                                if ( $post_object ) {
                                    setup_postdata( $GLOBALS['post'] =& $post_object );
                                    global $post;
                            ?>
                                <div class="listing-grid-slider-wrapper d-flex flex-column justify-content-end" <?php echo trim($style_bg); ?>>
                                    <div class="listing-grid-slider-v2">
                                                <div class="listing-grid-slider">
                                                    <div class="d-xl-flex align-items-center">
                                                        <div class="inner-left">
                                                            <div class="inner">
                                                                <?php boxcar_listing_display_price($post); ?>

                                                                <?php the_title( sprintf( '<h2 class="listing-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
                                                            </div>
                                                        </div>
                                                        <div class="inner-right d-inline-flex d-xl-flex flex-xl-column align-items-end align-items-xl-start ms-xl-auto">
                                                            <?php
                                                            $meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
                                                            $unit = wp_cardealer_get_option('search_distance_unit', 'miles');
                                                            if ( $unit == 'miles' ) {
                                                                $unit = esc_html__('Miles', 'boxcar');
                                                            } elseif( $unit == 'km' ) {
                                                                $unit = esc_html__('Km', 'boxcar');
                                                            }
                                                            $mileage = boxcar_listing_display_meta($post, 'mileage', 'flaticon-speedometer', true, $unit);
                                                            $fuel_type = boxcar_listing_display_tax_without_url($post, 'fuel_type', 'flaticon-gasoline-pump', true, false );
                                                            $transmission = boxcar_listing_display_tax_without_url($post, 'transmission', 'flaticon-gearbox', true, false );
                                                            $year = boxcar_listing_display_meta($post, 'year', 'flaticon-calendar-1', true, false );

                                                            if ( $mileage || $transmission || $fuel_type || $year ) {
                                                            ?>
                                                                <?php
                                                                    echo trim($fuel_type);
                                                                    echo trim($mileage);
                                                                    echo trim($transmission);
                                                                    echo trim($year);
                                                                ?>
                                                            <?php } ?>
                                                            <div class="more-link d-none d-md-block">
                                                                <a class="btn btn-white" href="<?php the_permalink(); ?>"><?php echo esc_html__('Learn More','boxcar'); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                                                <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
                                                                </svg></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                    <?php wp_reset_postdata(); ?>
                                    </div>
                                </div>
                            <?php 
                                }
                            } 
                            ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php } ?>
        </div>
        <?php
        }
    }
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_CarDealer_Listings_Slider );
