<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_CarDealer_Listings_Slider_Special extends Elementor\Widget_Base {

    public function get_name() {
        return 'apus_element_cardealer_listings_slider_special';
    }

    public function get_title() {
        return esc_html__( 'Apus Listings Slider Special', 'boxcar' );
    }
    
    public function get_categories() {
        return [ 'boxcar-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Listings', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'listing_id', [
                'label' => esc_html__( 'Listing ID', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter listing ID', 'boxcar' ),
            ]
        );

        $repeater->add_control(
            'image',
            [
                'name' => 'image',
                'label' => esc_html__( 'Image Background', 'boxcar' ),
                'type' => Elementor\Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Background Here', 'boxcar' ),
            ]
        );

        $this->add_control(
            'sliders',
            [
                'label' => esc_html__( 'Sliders', 'boxcar' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'placeholder' => esc_html__( 'Enter your listing tabs here', 'boxcar' ),
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
                'default' => 'large',
                'separator' => 'none',
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label'         => esc_html__( 'Show Navigation', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label'         => esc_html__( 'Show Pagination', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'boxcar'),
                    'st_transparent' => esc_html__('Transparent', 'boxcar'),
                ),
                'default' => ''
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_typography_style',
            [
                'label' => esc_html__( 'Typography', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'typography_title',
                'scheme' => Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->add_control(
            'des_color',
            [
                'label' => esc_html__( 'Description Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .desc' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'typography_des',
                'scheme' => Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .desc',
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        if ( !empty($sliders) ) {

            if ( $image_size == 'custom' ) {
                
                if ( $image_custom_dimension['width'] && $image_custom_dimension['height'] ) {
                    $thumbsize = $image_custom_dimension['width'].'x'.$image_custom_dimension['height'];
                } else {
                    $thumbsize = 'full';
                }
            } else {
                $thumbsize = $image_size;
            }
        ?>
        <div class="widget-listings-slider-special <?php echo esc_attr($el_class); ?>">

            <div class="slick-carousel carousel-slider-special no-gap <?php echo esc_attr($style); ?>" data-centerMode="true" data-items="3" data-smallmedium="1" data-extrasmall="1" data-pagination="<?php echo esc_attr( $show_pagination ? 'true' : 'false' ); ?>" data-nav="<?php echo esc_attr( $show_nav ? 'true' : 'false' ); ?>" data-infinite="true" data-autoplay="<?php echo esc_attr( $autoplay ? 'true' : 'false' ); ?>">
                <?php foreach ($sliders as $slider): ?>
                    <div class="item">
                        <?php
                        if ( !empty($slider['listing_id']) ) {

                            $post_object = get_post( $slider['listing_id'] );
                            if ( $post_object ) {
                                setup_postdata( $GLOBALS['post'] =& $post_object );
                                global $post;
                                ?>
                                    <div class="listing-grid-special listing-item <?php echo esc_attr($style); ?>">

                                        <div class="listing-content flex-column flex-middle">
                                            <?php boxcar_listing_display_price($post); ?>

                                            <?php the_title( sprintf( '<h2 class="listing-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
                                            
                                            <?php boxcar_listing_display_rating($post); ?>

                                            <?php
                                            $meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

                                            $mileage = boxcar_listing_display_meta($post, 'mileage', 'flaticon-road-perspective', false);
                                            $fuel_type = boxcar_listing_display_tax_without_url($post, 'fuel_type', 'flaticon-gas-station', false, false );
                                            $transmission = boxcar_listing_display_tax_without_url($post, 'transmission', 'flaticon-gear', false, false );

                                            if ( $mileage || $transmission || $fuel_type ) {
                                            ?>
                                                <div class="listing-metas flex flex-wrap">
                                                    <?php
                                                        echo trim($mileage);
                                                        echo trim($fuel_type);
                                                        echo trim($transmission);
                                                    ?>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <?php if ( !empty($slider['image']['id']) ) { ?>
                                            <div class="listing-image">
                                                <?php echo boxcar_get_attachment_thumbnail($slider['image']['id'], $thumbsize); ?>
                                            </div>
                                        <?php } ?>
                                    </div>

                                <?php

                                wp_reset_postdata();
                            }
                        }
                        ?>
                    </div>
                <?php endforeach; ?>
            </div>

        </div>
        <?php
        }
    }
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_CarDealer_Listings_Slider_Special );
