<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


class Boxcar_Elementor_Widget_Detail_Listing_Tagline extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_listing_tagline';
	}

	public function get_title() {
		return esc_html__( 'Listing Details:: Tagline', 'boxcar' );
	}

	public function get_icon() {
		return 'eicon-type-tool';
	}

	public function get_categories() {
		return [ 'boxcar-listing-detail-elements' ];
	}

	public function get_keywords() {
		return [ 'heading', 'title', 'text' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Tagline', 'boxcar' ),
			]
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'boxcar' ),
				'type' => Elementor\Controls_Manager::SELECT,
				'options' => [
					'div' => 'div',
					'span' => 'span',
					'p' => 'p',
				],
				'default' => 'div',
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'boxcar' ),
				'tab' => Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'tagline_color',
			[
				'label' => esc_html__( 'Text Color', 'boxcar' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => Elementor\Core\Schemes\Color::get_type(),
					'value' => Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					// Stronger selector to avoid section style from overwriting
					'{{WRAPPER}} .listing-tagline' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'scheme' => Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .listing-tagline',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

		if ( boxcar_is_listing_single_page() ) {
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$listings = boxcar_get_listings($args);
			if ( !empty($listings->posts) ) {
				$post_id = $listings->posts[0];
			}
		}
		if ( !empty($post_id) ) {
			?>
			<div class="listing-detail-tagline <?php echo esc_attr($el_class); ?>">
				<?php
				$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post_id);
				if ( $meta_obj->check_post_meta_exist('tagline') && ($tagline = $meta_obj->get_post_meta('tagline')) ) {

					$tagline_html = sprintf( '<%1$s class="listing-tagline">%2$s</%1$s>', $settings['header_size'], $tagline );

					echo trim($tagline_html);
				}
				?>
			</div>
			<?php
		}
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Listing_Tagline );
