<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Listing_Related extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_listing_related';
	}

	public function get_title() {
		return esc_html__( 'Listing Details:: Related', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Listings', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => esc_html__( 'Enter your title here', 'boxcar' ),
            ]
        );

		$this->add_control(
            'limit',
            [
                'label' => esc_html__( 'Limit', 'boxcar' ),
                'type' => Elementor\Controls_Manager::NUMBER,
                'input_type' => 'number',
                'description' => esc_html__( 'Limit listings to display', 'boxcar' ),
                'default' => 4
            ]
        );

		$this->add_control(
            'listing_item_style',
            [
                'label' => esc_html__( 'Listing Item Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid Default', 'boxcar'),
                ),
                'default' => 'grid'
            ]
        );

		$this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid', 'boxcar'),
                    'carousel' => esc_html__('Carousel', 'boxcar'),
                ),
                'default' => 'grid'
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 3,
            ]
        );

        $this->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__( 'Slides to Scroll', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'boxcar' ),
                'options' => $columns,
                'condition' => [
                    'columns!' => '1',
                    'layout_type' => 'carousel',
                ],
                'frontend_available' => true,
                'default' => 1,
            ]
        );

        $this->add_control(
            'rows',
            [
                'label' => esc_html__( 'Rows', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'number',
                'placeholder' => esc_html__( 'Enter your rows number here', 'boxcar' ),
                'default' => 1,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label'         => esc_html__( 'Show Navigation', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label'         => esc_html__( 'Show Pagination', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );


        $this->add_control(
            'slider_autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label'         => esc_html__( 'Infinite Loop', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'position_nav',
            [
                'label' => esc_html__( 'Position Nav', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'boxcar'),
                    'nav-bottom' => esc_html__('Bottom', 'boxcar'),
                ),
                'default' => '',
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
            'section_box_style',
            [
                'label' => esc_html__( 'Title', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
        if ( boxcar_is_listing_single_page() ) {
        	global $post;
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$listings = boxcar_get_listings($args);
			if ( !empty($listings->posts) ) {
				$post_id = $listings->posts[0];
				$post = get_post($post_id);
			}
		}
		if ( !empty($post) ) {
	        ?>
			<div class="listing-detail-related <?php echo esc_attr($el_class); ?>">
				<?php
				
				$tax_query = array();
				$terms = get_the_terms( $post->ID, 'listing_type' );
				$similar_url = WP_CarDealer_Mixes::get_listings_page_url();
				if ($terms) {
				    $termids = array();
				    foreach($terms as $term) {
				        $termids[] = $term->term_id;
				        $similar_url = add_query_arg( 'filter-type', $term->slug, $similar_url );
				    }
				    $tax_query[] = array(
				        'taxonomy' => 'listing_type',
				        'field' => 'id',
				        'terms' => $termids,
				        'operator' => 'IN'
				    );
				}

				if ( empty($tax_query) ) {
				    return;
				}
				$args = array(
				    'post_type' => 'listing',
				    'posts_per_page' => $limit,
				    'post__not_in' => array( $post->ID ),
				    'tax_query' => array_merge(array( 'relation' => 'AND' ), $tax_query)
				);
				$loop = WP_CarDealer_Query::get_posts( $args, true );

				if( $loop->have_posts() ):
				        $columns = !empty($columns) ? $columns : 3;
			            $columns_tablet = !empty($columns_tablet) ? $columns_tablet : 2;
			            $columns_mobile = !empty($columns_mobile) ? $columns_mobile : 1;
			            
			            $slides_to_scroll = !empty($slides_to_scroll) ? $slides_to_scroll : 1;
			            $slides_to_scroll_tablet = !empty($slides_to_scroll_tablet) ? $slides_to_scroll_tablet : $columns_tablet;
			            $slides_to_scroll_mobile = !empty($slides_to_scroll_mobile) ? $slides_to_scroll_mobile : $columns_mobile;
		            ?>
		            <div class="widget-listings <?php echo esc_attr($layout_type.' item-'.$listing_item_style); ?> <?php echo esc_attr($el_class); ?>">
		                
		                <div class="d-md-flex align-items-center top-related">
		                    <?php if ( $title ) { ?>
	                            <h4 class="title"><?php echo esc_html($title); ?></h4>
	                        <?php } ?>
		                    <div class="ms-auto">
		                        <a href="<?php echo esc_url($similar_url); ?>" class="btn-readmore"><?php esc_html_e( 'View All', 'boxcar' ); ?>
		                        	<svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg>
		                        </a>
		                    </div>
		                </div>

		                <div class="widget-content">
		                    <?php if ( $layout_type == 'carousel' ): ?>
		                        <div class="slick-carousel <?php echo esc_attr($columns < $loop->post_count?'':'hidden-dots'); ?> <?php echo esc_attr($position_nav); ?>"
		                            data-items="<?php echo esc_attr($columns); ?>"
			                        data-large="<?php echo esc_attr( $columns_tablet ); ?>"
			                        data-medium="<?php echo esc_attr( $columns_tablet ); ?>"
			                        data-small="<?php echo esc_attr($columns_mobile); ?>"
			                        data-smallest="<?php echo esc_attr($columns_mobile); ?>"

			                        data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
			                        data-slidestoscroll_large="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
			                        data-slidestoscroll_medium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
			                        data-slidestoscroll_small="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
			                        data-slidestoscroll_smallest="<?php echo esc_attr($slides_to_scroll_mobile); ?>"

		                            data-pagination="<?php echo esc_attr( $show_pagination ? 'true' : 'false' ); ?>" data-nav="<?php echo esc_attr( $show_nav ? 'true' : 'false' ); ?>" data-rows="<?php echo esc_attr( $rows ); ?>" data-infinite="<?php echo esc_attr( $infinite_loop ? 'true' : 'false' ); ?>" data-autoplay="<?php echo esc_attr( $slider_autoplay ? 'true' : 'false' ); ?>">
		                            <?php while ( $loop->have_posts() ): $loop->the_post(); ?>
		                                <div class="item">
		                                    <?php echo WP_CarDealer_Template_Loader::get_template_part( 'listings-styles/inner-'. $listing_item_style ); ?>
		                                </div>
		                            <?php endwhile; ?>
		                        </div>
		                    <?php else: ?>
		                        <?php
		                            $mdcol = 12/$columns;
		                            $smcol = 12/$columns_tablet;
		                            $xscol = 12/$columns_mobile;
		                        ?>
		                        <div class="row">
		                            <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
		                                <div class="col-xl-<?php echo esc_attr($mdcol); ?> col-md-<?php echo esc_attr($smcol); ?> col-<?php echo esc_attr( $xscol ); ?> list-item">
		                                    <?php echo WP_CarDealer_Template_Loader::get_template_part( 'listings-styles/inner-'. $listing_item_style ); ?>
		                                </div>
		                            <?php endwhile; ?>
		                        </div>
		                    <?php endif; ?>
		                    <?php wp_reset_postdata(); ?>
		                </div>
		            </div>
				<?php endif; ?>
			</div>
			<?php
	    }
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Listing_Related );
