<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Listing_Price extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_listing_price';
	}

	public function get_title() {
		return esc_html__( 'Listing Details:: Price', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Price', 'boxcar' ),
			]
		);

		$this->add_control(
            'show_saving',
            [
                'label' => esc_html__( 'Show Saving', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => 'on',
                'label_on' => esc_html__( 'Hide', 'boxcar' ),
                'label_off' => esc_html__( 'Show', 'boxcar' ),
            ]
        );

		$this->add_control(
            'saving_text',
            [
                'label'         => esc_html__( 'Saving Text', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'  		=> 'Instant Saving:&#160;',
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Style', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Typography', 'boxcar' ),
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .listing-price',
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
        if ( boxcar_is_listing_single_page() ) {
        	global $post;
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$listings = boxcar_get_listings($args);
			if ( !empty($listings->posts) ) {
				$post_id = $listings->posts[0];
				$post = get_post($post_id);
			}
		}
		if ( !empty($post) ) {
	        ?>
			<div class="listing-detail-price <?php echo esc_attr($el_class); ?>">
				<?php boxcar_listing_display_price($post); ?>
				<?php
				if ( $show_saving ) {
					$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
					$old_price = $meta_obj->get_post_meta( 'old_price' );
					$price = $meta_obj->get_post_meta( 'price' );
					if ( !empty( $old_price ) && is_numeric( $old_price ) && !empty( $price ) && is_numeric( $price ) && ($old_price > $price) ) {
						$saving_price = $old_price - $price;
						?>
						<div class="saving-price">
							<?php
							echo trim($saving_text); 
							echo WP_CarDealer_Price::format_price( $saving_price );
							?>
						</div>
						<?php
					}
				}
				?>
			</div>
			<?php
	    }
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Listing_Price );
