<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Listing_Gallery extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_listing_gallery';
	}

	public function get_title() {
		return esc_html__( 'Listing Details:: Gallery', 'boxcar' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'boxcar-listing-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'boxcar' ),
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => esc_html__( 'Layout Type', 'boxcar' ),
				'type' => Elementor\Controls_Manager::SELECT,
				'default' => 'v1',
				'options' => [
					'v1' => esc_html__( 'V1', 'boxcar' ),
					'v2' => esc_html__( 'V2', 'boxcar' ),
					'v3' => esc_html__( 'V3', 'boxcar' ),
				],
			]
		);

		$this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default' => 'full',
                'separator' => 'none',
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default' => 'full',
                'separator' => 'none',
                'condition' => [
                    'layout_type' => 'v1',
                ],
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );
        
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings );

		if ( boxcar_is_listing_single_page() ) {
			global $post;
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$listings = boxcar_get_listings($args);
			if ( !empty($listings->posts) ) {
				$post_id = $listings->posts[0];
				$post = get_post($post_id);
				setup_postdata( $GLOBALS['post'] =& $post );
			}
		}
		if ( !empty($post) ) {
			?>
			<div class="detail-gallery <?php echo esc_attr($el_class); ?> <?php echo esc_attr($layout_type); ?>">
				<?php
					$args = array('post' => $post, 'layout_type' => $layout_type);
					if ( $image_size == 'custom' ) {
		                
		                if ( $image_custom_dimension['width'] && $image_custom_dimension['height'] ) {
		                    $imagesize = $image_custom_dimension['width'].'x'.$image_custom_dimension['height'];
		                } else {
		                    $imagesize = 'full';
		                }
		            } else {
		                $imagesize = $image_size;
		            }
		            $args['imagesize'] = $imagesize;

		            if ( $layout_type == 'v1' ) {
			            if ( $thumbnail_size == 'custom' ) {
			                
			                if ( $thumbnail_custom_dimension['width'] && $thumbnail_custom_dimension['height'] ) {
			                    $thumbnailsize = $thumbnail_custom_dimension['width'].'x'.$thumbnail_custom_dimension['height'];
			                } else {
			                    $thumbnailsize = 'full';
			                }
			            } else {
			                $thumbnailsize = $thumbnail_size;
			            }
			            $args['thumbnailsize'] = $thumbnailsize;
			            echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/gallery', $args );
		            } elseif ($layout_type == 'v2') {
		            	echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/gallery-v2', $args );
		            } else {
		            	echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/gallery-v3', $args );
		            }
				?>
			</div>
			<?php
			if ( !boxcar_is_listing_single_page() ) {
				wp_reset_postdata();
			}
		}
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Listing_Gallery );
