<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Listing_Favorite_Button extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_listing_favorite_button';
	}

	public function get_title() {
		return esc_html__( 'Listing Details:: Favorite Button', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Favorite', 'boxcar' ),
			]
		);

		$this->add_control(
			'add_text',
			[
				'label' => esc_html__( 'Add Text', 'boxcar' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'default' => 'Save',
			]
		);

		$this->add_control(
			'added_text',
			[
				'label' => esc_html__( 'Added Text', 'boxcar' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'default' => 'Saved',
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );
        
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
        if ( boxcar_is_listing_single_page() ) {
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$listings = boxcar_get_listings($args);
			if ( !empty($listings->posts) ) {
				$post_id = $listings->posts[0];
			}
		}
		if ( !empty($post_id) ) {
	        ?>
			<div class="listing-detail-favorite <?php echo esc_attr($el_class); ?>">
				<?php
					if ( boxcar_get_config('listing_enable_favorite', true) ) {
			            $args = array(
			                'added_icon_class' => 'flaticon-bookmark',
			                'add_icon_class' => 'flaticon-bookmark',
			                'show_text' => true,
			                'add_text' => $add_text,
			                'added_text' => $added_text,
			            );
			            WP_CarDealer_Favorite::display_favorite_btn($post_id, $args);
			        }
				?>
			</div>
			<?php
        }
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Listing_Favorite_Button );
