<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Listing_Description extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_listing_description';
	}

	public function get_title() {
		return esc_html__( 'Listing Details:: Description', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
        if ( boxcar_is_listing_single_page() ) {
        	global $post;
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$listings = boxcar_get_listings($args);
			if ( !empty($listings->posts) ) {
				$post_id = $listings->posts[0];
				$post = get_post($post_id);
			}
		}
		if ( !empty($post) ) {
	        ?>
			<div class="listing-detail-description <?php echo esc_attr($el_class); ?>">
				<?php echo wpautop(apply_filters( 'the_listing_description', trim( $post->post_content ), $post )); ?>
			</div>
			<?php
	    }
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Listing_Description );
