<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Listing_Breadcrumbs extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_listing_breadcrumbs';
	}

	public function get_title() {
		return esc_html__( 'Listing Details:: Breadcrumbs', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Breadcrumbs', 'boxcar' ),
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
		?>
		<div class="listing-detail-breadcrums <?php echo esc_attr($el_class); ?>">
			<?php boxcar_render_breadcrumbs_simple(); ?>
		</div>
		<?php
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Listing_Breadcrumbs );
