<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Listing_Author_Info extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_listing_author_info';
	}

	public function get_title() {
		return esc_html__( 'Listing Details:: Author Info', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'show_avarta',
            [
                'label'         => esc_html__( 'Show Avarta', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'default'       => 'yes',
            ]
        );

		$this->add_control(
            'show_address',
            [
                'label'         => esc_html__( 'Show Address', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'default'       => 'yes',
            ]
        );

		$this->add_control(
            'show_direction',
            [
                'label'         => esc_html__( 'Show Direction', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'default'       => 'yes',
            ]
        );

		$this->add_control(
            'show_phone',
            [
                'label'         => esc_html__( 'Show Phone', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'default'       => 'yes',
            ]
        );

		$this->add_control(
            'show_send_message',
            [
                'label'         => esc_html__( 'Show Send Message Button', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'default'       => 'yes',
            ]
        );

		$this->add_control(
            'show_whatsapp',
            [
                'label'         => esc_html__( 'Show Whatsapp', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'default'       => 'yes',
            ]
        );

		$this->add_control(
			'whatsapp_title',
			[
				'label' => esc_html__( 'Whatsapp Title', 'boxcar' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'default' => 'Chat Via Whatsapp',
				'condition' => [
                    'show_whatsapp' => 'yes',
                ],
			]
		);

		$this->add_control(
            'show_view_all',
            [
                'label'         => esc_html__( 'Show View All Cars', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'default'       => 'yes',
            ]
        );

		$this->add_control(
			'view_all_title',
			[
				'label' => esc_html__( 'View All Cars Title', 'boxcar' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'default' => 'View All stock at this dealer',
				'condition' => [
                    'show_view_all' => 'yes',
                ],
			]
		);

		$this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout Type', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'default' => esc_html__('Default', 'boxcar'),
                    'style1' => esc_html__('Style 1', 'boxcar'),
                ),
                'default' => 'default',
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
            'section_box_style',
            [
                'label' => esc_html__( 'Box', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label' => esc_html__( 'Background', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .user-content-wrapper' => 'background: {{VALUE}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__( 'Padding', 'boxcar' ),
                'type' => Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .user-content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => esc_html__( 'Border', 'boxcar' ),
                'selector' => '{{WRAPPER}} .user-content-wrapper',
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'boxcar' ),
                'type' => Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .user-content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => esc_html__( 'Box Shadow', 'boxcar' ),
                'selector' => '{{WRAPPER}} .user-content-wrapper',
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
            'section_button_message_style',
            [
                'label' => esc_html__( 'Button Message', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

	        $this->start_controls_tabs( 'tabs_button_style' );

	        $this->start_controls_tab(
	            'tab_button_normal',
	            [
	                'label' => esc_html__( 'Normal', 'boxcar' ),
	            ]
	        );

	        $this->add_control(
	            'button_text_color',
	            [
	                'label' => esc_html__( 'Text Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'default' => '',
	                'selectors' => [
	                    '{{WRAPPER}} .send-private-message-btn ' => 'fill: {{VALUE}}; color: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->add_control(
	            'background_color',
	            [
	                'label' => esc_html__( 'Background Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .send-private-message-btn ' => 'background-color: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->add_group_control(
                Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'border_button',
                    'label' => esc_html__( 'Border', 'boxcar' ),
                    'selector' => '{{WRAPPER}} .send-private-message-btn ',
                ]
            );

	        $this->end_controls_tab();

	        $this->start_controls_tab(
	            'tab_button_hover',
	            [
	                'label' => esc_html__( 'Hover', 'boxcar' ),
	            ]
	        );

	        $this->add_control(
	            'hover_color',
	            [
	                'label' => esc_html__( 'Text Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .send-private-message-btn:hover, {{WRAPPER}} .send-private-message-btn:focus' => 'color: {{VALUE}};',
	                    '{{WRAPPER}} .send-private-message-btn:hover svg, {{WRAPPER}} .send-private-message-btn:focus svg' => 'fill: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->add_control(
	            'button_background_hover_color',
	            [
	                'label' => esc_html__( 'Background Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .send-private-message-btn:hover, {{WRAPPER}} .send-private-message-btn:focus' => 'background-color: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->add_control(
	            'button_hover_border_color',
	            [
	                'label' => esc_html__( 'Border Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'condition' => [
	                    'border_button_border!' => '',
	                ],
	                'selectors' => [
	                    '{{WRAPPER}} .send-private-message-btn:hover, {{WRAPPER}} .send-private-message-btn:focus' => 'border-color: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->end_controls_tab();

	        $this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
            'section_button_whatsapp_style',
            [
                'label' => esc_html__( 'Button Whatsapp', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

	        $this->start_controls_tabs( 'tabs_button_whatsapp_style' );

	        $this->start_controls_tab(
	            'tab_button_whatsapp_normal',
	            [
	                'label' => esc_html__( 'Normal', 'boxcar' ),
	            ]
	        );

	        $this->add_control(
	            'button_whatsapp_text_color',
	            [
	                'label' => esc_html__( 'Text Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'default' => '',
	                'selectors' => [
	                    '{{WRAPPER}} .btn-whatsapp ' => 'fill: {{VALUE}}; color: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->add_control(
	            'whatsapp_background_color',
	            [
	                'label' => esc_html__( 'Background Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .btn-whatsapp ' => 'background-color: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->add_group_control(
                Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'whatsapp_border_button',
                    'label' => esc_html__( 'Border', 'boxcar' ),
                    'selector' => '{{WRAPPER}} .btn-whatsapp ',
                ]
            );

	        $this->end_controls_tab();

	        $this->start_controls_tab(
	            'tab_button_whatsapp_hover',
	            [
	                'label' => esc_html__( 'Hover', 'boxcar' ),
	            ]
	        );

	        $this->add_control(
	            'whatsapp_hover_color',
	            [
	                'label' => esc_html__( 'Text Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .btn-whatsapp:hover, {{WRAPPER}} .btn-whatsapp:focus' => 'color: {{VALUE}};',
	                    '{{WRAPPER}} .btn-whatsapp:hover svg, {{WRAPPER}} .btn-whatsapp:focus svg' => 'fill: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->add_control(
	            'whatsapp_button_background_hover_color',
	            [
	                'label' => esc_html__( 'Background Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .btn-whatsapp:hover, {{WRAPPER}} .btn-whatsapp:focus' => 'background-color: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->add_control(
	            'whatsapp_button_hover_border_color',
	            [
	                'label' => esc_html__( 'Border Color', 'boxcar' ),
	                'type' => Elementor\Controls_Manager::COLOR,
	                'condition' => [
	                    'border_button_border!' => '',
	                ],
	                'selectors' => [
	                    '{{WRAPPER}} .btn-whatsapp:hover, {{WRAPPER}} .btn-whatsapp:focus' => 'border-color: {{VALUE}};',
	                ],
	            ]
	        );

	        $this->end_controls_tab();

	        $this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
        if ( boxcar_is_listing_single_page() ) {
        	global $post;
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$listings = boxcar_get_listings($args);
			if ( !empty($listings->posts) ) {
				$post_id = $listings->posts[0];
				$post = get_post($post_id);
			}
		}
		if ( !empty($post) ) {
			$author_id = $post->post_author;
			$user = get_userdata( $author_id );
			
			$author_phone = get_user_meta($author_id, '_user_phone', true);
			$author_address = get_user_meta($author_id, '_user_address', true);
			$location = get_user_meta( $author_id, '_user_map_location_address', true );
	
			if ( empty($location) ) {
				$location = $author_address;
			}
			$author_phone = boxcar_user_display_phone($author_phone, 'no-title', false, true);

			$whatsapp = get_user_meta($author_id, '_user_whatsapp', true);

			$display_name = $user->display_name;
			if ( class_exists('WP_CarDealer_Dealer') ) {
				if ( WP_CarDealer_User::is_dealer($author_id) ) {
					$dealer_id = WP_CarDealer_User::get_dealer_by_user_id($author_id);
					$dealer_obj = get_post($dealer_id);
					$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($dealer_id);
					
					$display_name = get_the_title($dealer_id);
					$author_phone = boxcar_dealer_author_phone($dealer_obj, 'no-title', false, true);

					if ( $meta_obj->check_post_meta_exist('whatsapp') ) {
						$whatsapp = $meta_obj->get_post_meta( 'whatsapp' );
					}
					$author_address = '';
					if ( $meta_obj->check_post_meta_exist('address') ) {
						$author_address = $meta_obj->get_post_meta( 'address' );
						
					}
					$location = '';
					if ( $meta_obj->check_post_meta_exist('map_location') ) {
						$location = $meta_obj->get_post_meta( 'map_location_address' );
					
						if ( empty($location) ) {
							$location = $author_address;
						}
					}
				}
			}
	        ?>
			<div class="listing-detail-author-info <?php echo esc_attr($el_class. ' '. $layout_type); ?>">
				<div class="user-content-wrapper">
					<?php if ( $show_avarta ) { ?>
						<div class="user-thumbnail d-flex align-items-center justify-content-center">
							<a href="<?php echo esc_url( get_author_posts_url( $author_id ) ); ?>">
								<?php echo boxcar_get_avatar($post->post_author, 180); ?>
							</a>
						</div>
					<?php } ?>

					<div class="user-content">
						<h3 class="title-user"><a href="<?php echo esc_url( get_author_posts_url( $author_id ) ); ?>"><?php echo esc_html($display_name); ?></a></h3>

						<?php if ( $show_address && $author_address ) { ?>
							<div class="author-address"><?php echo esc_html($author_address); ?></div>
						<?php } ?>

						<?php if ($show_phone && $show_direction && $author_phone && $location) { ?>
							<div class="d-flex align-items-center justify-content-between user-content">
								<?php if ( $show_direction && $location ) { ?>
									<div class="flex-info-author d-flex align-items-center">
										<span class="icon flex-shrink-0 d-flex align-items-center justify-content-center"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
<path fill-rule="evenodd" clip-rule="evenodd" d="M9 2.8125C6.00839 2.8125 3.5625 5.29431 3.5625 8.38163C3.5625 9.9384 4.18517 11.6625 5.20406 12.9938C6.22558 14.3287 7.57762 15.1875 9 15.1875C10.4224 15.1875 11.7744 14.3287 12.796 12.9938C13.8148 11.6625 14.4375 9.9384 14.4375 8.38163C14.4375 5.29431 11.9916 2.8125 9 2.8125ZM2.4375 8.38163C2.4375 4.69613 5.36419 1.6875 9 1.6875C12.6358 1.6875 15.5625 4.69613 15.5625 8.38163C15.5625 10.2113 14.8421 12.1714 13.6894 13.6775C12.5393 15.1803 10.8913 16.3125 9 16.3125C7.10866 16.3125 5.46071 15.1803 4.31065 13.6775C3.15797 12.1714 2.4375 10.2113 2.4375 8.38163Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M6.5625 7.875C6.5625 6.5288 7.65383 5.4375 9 5.4375C10.3462 5.4375 11.4375 6.5288 11.4375 7.875C11.4375 9.22117 10.3462 10.3125 9 10.3125C7.65383 10.3125 6.5625 9.22117 6.5625 7.875ZM9 6.5625C8.27513 6.5625 7.6875 7.15013 7.6875 7.875C7.6875 8.59987 8.27513 9.1875 9 9.1875C9.72487 9.1875 10.3125 8.59987 10.3125 7.875C10.3125 7.15013 9.72487 6.5625 9 6.5625Z" fill="currentColor"/>
</svg></span>

										<a href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php esc_html_e('Get Direction', 'boxcar'); ?></a>
									</div>
								<?php } ?>
								<?php if ( $show_phone && $author_phone ) { ?>
									<div class="flex-info-author d-flex align-items-center">
										<span class="icon flex-shrink-0 d-flex align-items-center justify-content-center"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
<path d="M16.2778 7.60745C15.9951 7.60745 15.7521 7.39523 15.7198 7.10798C15.4348 4.57598 13.4676 2.61098 10.9356 2.32973C10.6273 2.29523 10.4046 2.01773 10.4391 1.70873C10.4728 1.40048 10.7496 1.17023 11.0601 1.21223C14.1178 1.55123 16.4938 3.92423 16.8373 6.98198C16.8726 7.29098 16.6498 7.5692 16.3416 7.6037C16.3206 7.60595 16.2988 7.60745 16.2778 7.60745Z" fill="currentColor"/>
<path d="M13.6222 7.61567C13.3582 7.61567 13.1235 7.42967 13.071 7.16117C12.855 6.05117 11.9992 5.19542 10.8907 4.98017C10.5855 4.92092 10.3867 4.62617 10.446 4.32092C10.5052 4.01567 10.8075 3.81692 11.1052 3.87617C12.666 4.17917 13.8712 5.38367 14.175 6.94517C14.2342 7.25117 14.0355 7.54592 13.731 7.60517C13.6942 7.61192 13.6582 7.61567 13.6222 7.61567Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.61174 12.3302C9.14652 15.8657 11.5 16.7927 12.9865 16.7927C13.72 16.7927 14.2435 16.567 14.5923 16.3165C14.608 16.3075 16.222 15.3205 16.5048 13.8265C16.6383 13.1252 16.4433 12.4315 15.9423 11.8195C13.8783 9.31374 12.8268 9.54774 11.6658 10.1125C10.9525 10.462 10.3893 10.7335 8.79852 9.14424C7.20867 7.55372 7.48293 6.9904 7.83012 6.27727C8.39562 5.11627 8.62827 4.06451 6.12174 1.99901C5.51124 1.50026 4.82199 1.30526 4.12149 1.43651C2.64924 1.71176 1.65774 3.29951 1.65774 3.29951C0.868736 4.40726 0.333239 7.05252 5.61174 12.3302ZM4.35099 2.53751C4.41699 2.52701 4.48224 2.52101 4.54674 2.52101C4.84074 2.52101 5.12424 2.63576 5.40699 2.86826C7.42822 4.53325 7.17249 5.05826 6.81849 5.785C6.28674 6.87775 6.00849 7.94424 8.00277 9.93999C9.99927 11.9357 11.0665 11.6575 12.1578 11.1242L12.1596 11.1233C12.8854 10.7705 13.4102 10.5155 15.073 12.5342C15.3573 12.8807 15.466 13.2272 15.4045 13.5925C15.2628 14.4325 14.2863 15.1847 13.9908 15.3677C12.9325 16.1222 10.3848 15.5125 6.40674 11.5352C2.43024 7.55799 1.81974 5.01026 2.60124 3.91151C2.75724 3.65726 3.51249 2.67926 4.35099 2.53751Z" fill="currentColor"/>
</svg></span>
										<?php echo trim($author_phone); ?></div>
								<?php } ?>
							</div>
						<?php } ?>
					</div>
					<div class="user-content-bottom d-flex flex-column">
						
						<?php
						if ( $show_send_message ) {
							do_action('wp-cardealer-single-listing-contact-form', $post, $author_id);
						}
						?>

						<?php if ( $show_whatsapp && $whatsapp ) { ?>
							<a class="btn btn-green btn-whatsapp w-100" href="https://api.whatsapp.com/send?phone=<?php echo esc_attr($whatsapp); ?>&text=Hello" target="_blank">
								<?php echo esc_html($whatsapp_title); ?>
								<svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg>
							</a>
						<?php } ?>

						<?php 
						if ( $show_view_all ) {
							$filter_url = WP_CarDealer_Mixes::get_listings_page_url();
							$filter_url = add_query_arg( 'filter-author', $author_id, $filter_url );
							?>
							<div class="text-center">
								<a class="btn-filter-author" href="<?php echo esc_url($filter_url); ?>" target="_blank">
									<?php echo esc_html($view_all_title); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
	            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
	            </svg>
								</a>
							</div>
							<?php
						}
						?>
					</div>
				</div>
			</div>
			<?php
	    }
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Listing_Author_Info );
