<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Dealer_Single_Field extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_dealer_single_field';
	}

	public function get_title() {
		return esc_html__( 'Dealer Details:: Single Field Data', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-dealer-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Field', 'boxcar' ),
			]
		);

		$fields = WP_CarDealer_Custom_Fields::get_custom_fields(array(), false, 0, WP_CARDEALER_DEALER_PREFIX);
        $all_fields = array( '' => esc_html__('Choose a field', 'boxcar') );
        if ( !empty($fields) ) {
	        foreach ($fields as $key => $field) {
	        	if ( $field['type'] !== 'title' ) {
		            $name = $field['name'];
		            if ( empty($field['name']) ) {
		                $name = $field['id'];
		            }
		            $all_fields[$field['id']] = $name;
		        }
	        }
        }

        $this->add_control(
            'show_field',
            [
                'label' => esc_html__( 'Show field', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $all_fields
            ]
        );

        $this->add_control(
            'show_url',
            [
                'label'         => esc_html__( 'Show URL', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'show_field' => array('_dealer_location', '_dealer_category'),
                ],
            ]
        );

		$this->add_control(
			'selected_icon',
			[
				'label' => esc_html__( 'Icon', 'boxcar' ),
				'type' => Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
			'suffix',
			[
				'label' => esc_html__( 'Suffix', 'boxcar' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'default' => '',
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
        if ( boxcar_is_dealer_single_page() ) {
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$dealers = boxcar_get_dealers($args);
			if ( !empty($dealers->posts) ) {
				$post_id = $dealers->posts[0];
			}
		}
		if ( !empty($post_id) ) {
			$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post_id);
			?>
			<div class="dealer-detail-field <?php echo esc_attr($el_class); ?>">
				<?php
				$value_html = '';
				$taxs = array('_dealer_location', '_dealer_category');
				
				if ( in_array($show_field, $taxs) ) {
					if ( $meta_obj->check_custom_post_meta_exist($show_field) ) {
						$tax_values = get_the_terms( $post_id, ltrim($show_field, '_') );
						if ( $tax_values && ! is_wp_error( $tax_values ) ) {
							$number = 1;
							ob_start();
							foreach ($tax_values as $term) {
								if ( $show_url ) {
								?>
					            	<a class="dealer-tax" href="<?php echo esc_url(get_term_link($term)); ?>"><?php echo esc_html($term->name); ?></a><?php if($number < count($tax_values)) echo trim(', ');?>
					        	<?php
					        	} else {
					        		?>
					        		<span class="dealer-tax"><?php echo esc_html($term->name); ?></span><?php if($number < count($tax_values)) echo trim(', ');?>
					        		<?php
					        	}
					        	$number++;
					    	}
					    	$value_html = ob_get_clean();
						}
					}
				} else {
					if ( $meta_obj->check_custom_post_meta_exist($show_field) && ($value = $meta_obj->get_custom_post_meta($show_field)) ) {
						$value_html = is_array($value) ? implode(', ', $value) : $value;
						
					}
				}
				?>
				<div class="meta-dealer-item d-inline-flex align-items-center">
					<?php

					if ( empty( $settings['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
						// add old default
						$settings['icon'] = 'fa fa-star';
					}

					if ( ! empty( $settings['icon'] ) ) {
						$this->add_render_attribute( 'icon', 'class', $settings['icon'] );
						$this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
					}

					$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
					$is_new = empty( $settings['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
					if ( $is_new || $migrated ) { ?>
						<span class="pre"><?php Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
					<?php } else { ?>
						<span class="pre"><i <?php $this->print_render_attribute_string( 'icon' ); ?>></i></span>
					<?php } ?>
					<span class="content-value">
						<?php echo trim($value_html); ?>
					</span>
					<?php if ( $suffix ) { ?>
						<span class="suffix"><?php echo trim($suffix); ?></span>
					<?php } ?>
				</div>
			</div>
			<?php
        }
	}
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Dealer_Single_Field );
