<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Dealer_Reviews extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_dealer_reviews';
	}

	public function get_title() {
		return esc_html__( 'Dealer Details:: Reviews', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-dealer-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
        if ( boxcar_is_dealer_single_page() ) {
        	global $post;
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$dealers = boxcar_get_dealers($args);
			if ( !empty($dealers->posts) ) {
				$post_id = $dealers->posts[0];
				$post = get_post($post_id);
				setup_postdata( $GLOBALS['post'] =& $post );
			}
		}
		if ( !empty($post) ) {
	        ?>
			<div class="dealer-detail-reviews <?php echo esc_attr($el_class); ?>">
				<?php if ( WP_CarDealer_Review::review_enable() ) { ?>
						<?php comments_template(); ?>
				<?php } ?>
			</div>
			<?php
			if ( !boxcar_is_dealer_single_page() ) {
				wp_reset_postdata();
			}
	    }
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Dealer_Reviews );
