<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Dealer_Listings_Btn extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_dealer_listings_btn';
	}

	public function get_title() {
		return esc_html__( 'Dealer Details:: All Listings Button', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-dealer-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'btn_text',
            [
                'label'         => esc_html__( 'Button Text', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => 'View All',
            ]
        );

		$this->add_control(
            'btn_icon',
            [
                'label' => esc_html__( 'Button Icon', 'boxcar' ),
                'type' => Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'boxcar' ),
				'tab' => Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'btn_color',
			[
				'label' => esc_html__( 'Text Color', 'boxcar' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => Elementor\Core\Schemes\Color::get_type(),
					'value' => Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					// Stronger selector to avoid section style from overwriting
					'{{WRAPPER}} .btn-filter-author' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'scheme' => Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .btn-filter-author',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

		
		if ( boxcar_is_dealer_single_page() ) {
        	global $post;
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$dealers = boxcar_get_dealers($args);
			if ( !empty($dealers->posts) ) {
				$post_id = $dealers->posts[0];
				$post = get_post($post_id);
			}
		}
		if ( !empty($post) ) {
			$listings_url = WP_CarDealer_Mixes::get_listings_page_url();
            $listings_url = add_query_arg( 'filter-author', $post->post_author, $listings_url );
			?>
			<a class="btn-filter-author btn btn-theme btn-outline <?php echo esc_attr($el_class); ?>" href="<?php echo esc_url($listings_url); ?>" target="_blank">
				<?php echo esc_html($btn_text); ?>
				<?php if ( $btn_icon ) {
                    if ( empty( $settings['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
                        // add old default
                        $settings['icon'] = 'fa fa-star';
                    }

                    if ( ! empty( $settings['icon'] ) ) {
                        $this->add_render_attribute( 'icon', 'class', $settings['icon'] );
                        $this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
                    }

                    $migrated = isset( $settings['__fa4_migrated']['btn_icon'] );
                    $is_new = empty( $settings['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
                    if ( $is_new || $migrated ) { ?>
                    	<span class="next">
                        	<?php Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
                    <?php } else { ?>
                    	<span class="next">
	                        <i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
	                    </span>
                    <?php }
                } ?>
            </a>
			<?php
		}
	}
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Dealer_Listings_Btn );
