<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Dealer_Hours extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_dealer_hours';
	}

	public function get_title() {
		return esc_html__( 'Dealer Details:: Opening Hours', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-dealer-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'title',
            [
                'label'         => esc_html__( 'Title', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => 'Opening Hours',
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();


	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

		
		if ( boxcar_is_dealer_single_page() ) {
        	global $post;
			$post_id = get_the_ID();
			
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$dealers = boxcar_get_dealers($args);
			if ( !empty($dealers->posts) ) {
				$post_id = $dealers->posts[0];
				$post = get_post($post_id);
			}
		}
		if ( !empty($post) ) {
			$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);
			$hours = $meta_obj->get_post_meta( 'hours' );
			
			if ( empty($hours['day']) ) {
			    return;
			} else {
			    $hours = $hours['day'];
			}
			$days = boxcar_get_day_hours($hours);

			if ( ! empty ( $days ) ) {
			    $timezone = !empty($hours['timezone']) ? $hours['timezone'] : '';
			    $current = boxcar_get_current_time($timezone);
			    $output = '';
			    foreach ($days as $day => $times) {
			        $day_time = '';
			        if ( $times == 'open' ) {
			            $day_time = '<span class="open-text">'.esc_html__('Open All Day', 'boxcar').'</span>';
			        } elseif ( $times == 'closed' ) {
			            $day_time = '<span class="close-text">'.esc_html__('Closed All Day', 'boxcar').'</span>';
			        } elseif ( is_array($times) ) {
			            foreach ($times as $time) {
			                $day_time .= '<div class="time-items">';
			                    if ($time[0]) {
			                        $day_time .= '<span class="start">'.$time[0].'</span>';
			                    }
			                    if ($time[1]) {
			                        $day_time .= ' - <span class="end">'.$time[1].'</span>';
			                    }
			                $day_time .= '</div>';
			            }
			        }
			        $current_day_class = '';
			        if ( strtolower($current['day']) === strtolower($day) ) {
			            $current_day_class = 'current';
			        }
			        if ( !empty($day_time) ) {
			            $output .= '<div class="listing-day d-flex align-items-center '.$current_day_class.'">';
			                $output .= '<span class="day">'.$day.'</span>';
			                $output .= '<div class="bottom-inner ms-auto">'.$day_time.'</div>';
			            $output .= '</div>';
			        }
			    }
			    if ( !empty($output) ) {
			    ?>
			        <div class="user-hours <?php echo esc_attr($el_class); ?>">
			            <h2 class="widget-title d-flex align-items-center">
			                <?php if ($title) { ?>
								<span class="title">
									<?php echo esc_html($title); ?>
								</span>
							<?php } ?>
			                <span class="ms-auto hour-present">
			                    <?php boxcar_dealer_display_time_status($post); ?>
			                </span>
			            </h2>
			            <div class="clearfix">
			                <?php echo trim($output); ?>
			            </div>
			        </div>
			        <?php
			    }
			}
		}
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Dealer_Hours );
