<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_Dealer_Featured_Image extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_dealer_featured_image';
	}

	public function get_title() {
		return esc_html__( 'Dealer Details:: Featured Image', 'boxcar' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'boxcar-dealer-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'boxcar' ),
			]
		);

		$this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default' => 'full',
                'separator' => 'none',
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );
        
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings );

		if ( boxcar_is_dealer_single_page() ) {
			global $post;
			$post_id = get_the_ID();
		} else {
			$args = array(
				'limit' => 1,
				'fields' => 'ids',
			);
			$dealers = boxcar_get_dealers($args);
			if ( !empty($dealers->posts) ) {
				$post_id = $dealers->posts[0];
				$post = get_post($post_id);
			}
		}
		if ( !empty($post) ) {
			?>
			<div class="detail-featured-image <?php echo esc_attr($el_class); ?>">
				<div class="dealer-single-image d-inline-flex align-items-center justify-content-center">
					<?php
						if ( $image_size == 'custom' ) {
			                
			                if ( $image_custom_dimension['width'] && $image_custom_dimension['height'] ) {
			                    $imagesize = $image_custom_dimension['width'].'x'.$image_custom_dimension['height'];
			                } else {
			                    $imagesize = 'full';
			                }
			            } else {
			                $imagesize = $image_size;
			            }

			            boxcar_dealer_display_image($post, $imagesize);
					?>
				</div>
			</div>
			<?php
		}
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_Dealer_Featured_Image );
