<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Dealer_Archive_Listing_Items extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_dealer_archive_listing_items';
	}

	public function get_title() {
		return esc_html__( 'Dealer Archive:: Dealer Items', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-dealer-archive-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'dealer_item_style',
            [
                'label' => esc_html__( 'Dealer Item Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid Default', 'boxcar'),
                ),
                'default' => 'grid',
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 3,
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

        $args = array(
        	'settings' => $settings,
        );

        if ( Elementor\Plugin::$instance->editor->is_edit_mode() ) {
        	$query_args = array(
				'post_type' => 'dealer',
			    'post_status' => 'publish',
			    'posts_per_page' => 4,
			);

			$dealers = WP_CarDealer_Query::get_posts($query_args);
			$args['dealers'] = $dealers;
        } else {
	        global $boxcar_dealers;
	        $args['dealers'] = $boxcar_dealers;
	    }

		?>
		
		<div class="element-dealers-dealer-wrapper <?php esc_attr($el_class); ?>">
			<?php echo WP_CarDealer_Template_Loader::get_template_part('loop/dealer/archive-inner', $args); ?>
		</div>
		<?php
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Dealer_Archive_Listing_Items );
