<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Dashboard_Activities extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_dashboard_activities';
	}

	public function get_title() {
		return esc_html__( 'Dashboard:: Activities', 'boxcar' );
	}
	
	public function get_categories() {
		return [ 'boxcar-dashboard-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'boxcar' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'default' => 'Activities',
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

		?>
		<div class="dashboard-box box-white-dashboard <?php echo esc_attr($el_class); ?>">
			<?php if ( $title ) { ?>
				<h4 class="title"><?php echo esc_html($title); ?></h4>
			<?php } ?>
			<?php
			$user_id = get_current_user_id();
			$notifications = WP_CarDealer_User_Notification::get_notifications($user_id);
			if ( !empty($notifications) ) {
			?>
	            <div class="dashboard-notifications-wrapper">

	                <ul class="list-notifications">
	                    <?php foreach ($notifications as $key => $notify) {
	                        $type = !empty($notify['type']) ? $notify['type'] : '';
	                        if ( $type ) {
	                    ?>
	                            <li>
	                            	<span class="icons d-inline-flex align-items-center justify-content-center">
		                            	<?php
		                            	switch ($type) {
											case 'new_private_message':
												?>
												<i class="flaticon-chat"></i>
												<?php
												break;
											case 'approved_listing':
												?>
												<i class="flaticon-insurance"></i>
												<?php
												break;
											default:
												?>
												<i class="flaticon-bookmark"></i>
												<?php
												break;
										}
		                            	?>
	                            	</span>
	                            	<span class="text">
	                            		<div>
			                                <?php echo trim(WP_CarDealer_User_Notification::display_notify($notify)); ?>
			                            </div>
			                            <small class="time">
		                            		<?php
		                            			$time = $notify['time'];
		                            			echo human_time_diff( $time, current_time( 'timestamp' ) ).' '.esc_html__( 'ago', 'boxcar' );
		                            		?>
	                            		</small>
		                            </span>
	                            </li>
	                        <?php } ?>
	                    <?php } ?>
	                </ul>      
	            </div>
	        <?php } ?>
		</div>
		<?php
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Dashboard_Activities );
