<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Listing_Archive_Tax_Description extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_listing_archive_tax_description';
	}

	public function get_title() {
		return esc_html__( 'Listing Archive:: Taxonomy Description', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-archive-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'boxcar' ),
			]
		);


		$this->add_control(
			'taxs',
			[
				'label' => esc_html__( 'Taxonomies', 'boxcar' ),
				'type' => Elementor\Controls_Manager::SELECT2,
				'options' => array('category' => esc_html__( 'Category', 'boxcar' ), 'color' => esc_html__( 'Color', 'boxcar' ), 'condition' => esc_html__( 'Condition', 'boxcar' ), 'cylinder' => esc_html__( 'Cylinder', 'boxcar' ), 'door' => esc_html__( 'Door', 'boxcar' ), 'drive_type' => esc_html__( 'Drive Type', 'boxcar' ), 'feature' => esc_html__( 'Feature', 'boxcar' ), 'fuel_type' => esc_html__( 'Fuel Type', 'boxcar' ), 'location' => esc_html__( 'Location', 'boxcar' ), 'make' => esc_html__( 'Make', 'boxcar' ), 'model' => esc_html__( 'Model', 'boxcar' ), 'offer_type' => esc_html__( 'Offer Type', 'boxcar' ), 'safety_type' => esc_html__( 'Safety Type', 'boxcar' ), 'transmission' => esc_html__( 'Transmission', 'boxcar' ), 'type' => esc_html__( 'Type', 'boxcar' ), 'label' => esc_html__( 'Label', 'boxcar' )),
				'multiple' => true,
				'default' => [ 'category', 'type' ],
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'boxcar' ),
				'tab' => Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Text Color', 'boxcar' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => Elementor\Core\Schemes\Color::get_type(),
					'value' => Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					// Stronger selector to avoid section style from overwriting
					'{{WRAPPER}} .listing-tax-description' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'scheme' => Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .listing-tax-description',
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'text_shadow',
				'selector' => '{{WRAPPER}} .listing-tax-description',
			]
		);

		$this->add_control(
			'blend_mode',
			[
				'label' => esc_html__( 'Blend Mode', 'boxcar' ),
				'type' => Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Normal', 'boxcar' ),
					'multiply' => 'Multiply',
					'screen' => 'Screen',
					'overlay' => 'Overlay',
					'darken' => 'Darken',
					'lighten' => 'Lighten',
					'color-dodge' => 'Color Dodge',
					'saturation' => 'Saturation',
					'color' => 'Color',
					'difference' => 'Difference',
					'exclusion' => 'Exclusion',
					'hue' => 'Hue',
					'luminosity' => 'Luminosity',
				],
				'selectors' => [
					'{{WRAPPER}} .listing-tax-description' => 'mix-blend-mode: {{VALUE}}',
				],
				'separator' => 'none',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
		if ( !empty($taxs) && is_array($taxs) ) {
			foreach ($taxs as $tax) {
				if ( is_tax('listing_'.$tax) ) {
					global $wp_query;
					$term =	$wp_query->queried_object;
					if ( isset($term->description) ) {
						?>
						<div class="listing-tax-description <?php echo esc_attr($el_class); ?>">
							<?php echo wpautop($term->description); ?>
						</div>
						<?php
					}
				}
			}
		}
		?>
		
		<?php
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Listing_Archive_Tax_Description );
