<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Listing_Archive_Sortby extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_listing_archive_sortby';
	}

	public function get_title() {
		return esc_html__( 'Listing Archive:: Sort By', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-archive-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'title',
            [
                'label'         => esc_html__( 'Title', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   	=> 'Sort by',
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'boxcar' ),
				'tab' => Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Text Color', 'boxcar' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => Elementor\Core\Schemes\Color::get_type(),
					'value' => Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					// Stronger selector to avoid section style from overwriting
					'{{WRAPPER}} .results-count' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'scheme' => Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .results-count',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
        
		$orderby_options = apply_filters( 'wp-cardealer-listings-orderby', array(
			'menu_order' => esc_html__('Default', 'boxcar'),
			'newest' => esc_html__('Newest', 'boxcar'),
			'oldest' => esc_html__('Oldest', 'boxcar'),
			'price-lowest' => esc_html__('Lowest Price', 'boxcar'),
			'price-highest' => esc_html__('Highest Price', 'boxcar'),
			'random' => esc_html__('Random', 'boxcar'),
		));
		$orderby = isset( $_GET['filter-orderby'] ) ? wp_unslash( $_GET['filter-orderby'] ) : 'menu_order';
		if ( !WP_CarDealer_Mixes::is_ajax_request() ) {
			wp_enqueue_script('wpcd-select2');
			wp_enqueue_style('wpcd-select2');
		}
		?>
		<div class="listings-ordering-wrapper <?php echo esc_attr($el_class); ?>">
			<form class="listings-ordering" method="get" action="<?php echo WP_CarDealer_Mixes::get_listings_page_url(); ?>">
				<?php if ( $title ) { ?>
					<div class="label"><?php echo esc_html($title); ?></div>
				<?php } ?>
				<select name="filter-orderby" class="orderby" <?php if ( $title ) { ?>data-placeholder="<?php echo esc_attr($title); ?>" <?php } ?>>
					<?php foreach ( $orderby_options as $id => $name ) : ?>
						<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
					<?php endforeach; ?>
				</select>
				<input type="hidden" name="paged" value="1" />
				<?php WP_CarDealer_Mixes::query_string_form_fields( null, array( 'filter-orderby', 'submit', 'paged' ) ); ?>
			</form>
		</div>
		<?php
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Listing_Archive_Sortby );
