<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Listing_Archive_Pagination extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_listing_archive_pagination';
	}

	public function get_title() {
		return esc_html__( 'Listing Archive:: Pagination', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-archive-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'pagination_type',
            [
                'label' => esc_html__( 'Pagination Type', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'default' => esc_html__('Default', 'boxcar'),
		            'loadmore' => esc_html__('Load More Button', 'boxcar'),
		            'infinite' => esc_html__('Infinite Scrolling', 'boxcar'),
                ),
                'default' => 'default',
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );
        
		global $boxcar_listings;
		$args = array(
        	'listings' => $boxcar_listings,
        	'settings' => $settings,
        );
		?>
		<div class="elements-listings-pagination-wrapper <?php echo esc_attr($el_class); ?>">
			<?php echo WP_CarDealer_Template_Loader::get_template_part('loop/listing/pagination', $args); ?>
		</div>
		<?php
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Listing_Archive_Pagination );
