<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Listing_Archive_Listing_Items extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_listing_archive_listing_items';
	}

	public function get_title() {
		return esc_html__( 'Listing Archive:: Listing Items', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-listing-archive-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'listing_item_style',
            [
                'label' => esc_html__( 'Listing Item Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid Default', 'boxcar'),
                    'grid-v1' => esc_html__('Grid V1', 'boxcar'),
                    'grid-v2' => esc_html__('Grid V2', 'boxcar'),
                    'grid-v3' => esc_html__('Grid V3', 'boxcar'),
                    'grid-v4' => esc_html__('Grid V4', 'boxcar'),
                    'grid-v5' => esc_html__('Grid V5', 'boxcar'),
                    'list' => esc_html__('List Default', 'boxcar'),
                    'list-v1' => esc_html__('List v1', 'boxcar'),
                    'list-v2' => esc_html__('List v2', 'boxcar'),
                    'list-v3' => esc_html__('List v3', 'boxcar'),
                ),
                'default' => 'grid',
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 3,
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

        $args = array(
        	'settings' => $settings,
        );

        if ( Elementor\Plugin::$instance->editor->is_edit_mode() ) {
        	$query_args = array(
				'post_type' => 'listing',
			    'post_status' => 'publish',
			    'posts_per_page' => 4,
			);

			$listings = WP_CarDealer_Query::get_posts($query_args);
			$args['listings'] = $listings;
        } else {
	        global $boxcar_listings;
	        $args['listings'] = $boxcar_listings;
	    }

		?>
		
		<div class="eleemnt-listings-listing-wrapper <?php esc_attr($el_class); ?>">
			<?php echo WP_CarDealer_Template_Loader::get_template_part('loop/listing/archive-inner', $args); ?>
		</div>
		<?php
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Listing_Archive_Listing_Items );
