<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_Testimonials extends Widget_Base {

    public function get_name() {
        return 'apus_element_testimonials';
    }

    public function get_title() {
        return esc_html__( 'Apus Testimonials', 'boxcar' );
    }

    public function get_icon() {
        return 'eicon-testimonial';
    }

    public function get_categories() {
        return [ 'boxcar-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'boxcar' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'img_src',
            [
                'name' => 'image',
                'label' => esc_html__( 'Choose Image', 'boxcar' ),
                'type' => Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Brand Image', 'boxcar' ),
            ]
        );

        $repeater->add_control(
            'reviews',
            [
                'label' => esc_html__( 'Reviews', 'boxcar' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => esc_html__( 'Name', 'boxcar' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );

        $repeater->add_control(
            'content', [
                'label' => esc_html__( 'Content', 'boxcar' ),
                'type' => Controls_Manager::TEXTAREA
            ]
        );

        $repeater->add_control(
            'listing',
            [
                'label' => esc_html__( 'Job or Title', 'boxcar' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );
        $stars = range( 1, 5 );
        $stars = array_combine( $stars, $stars );

        $repeater->add_control(
            'star',
            [
                'label' => esc_html__( 'Star Scores', 'boxcar' ),
                'type' => Controls_Manager::SELECT,
                'options' => $stars,
                'frontend_available' => true,
                'default' => 5,
            ]
        );

        $repeater->add_control(
            'verified',
            [
                'label' => esc_html__( 'Verified', 'boxcar' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'No', 'boxcar' ),
                'label_off' => esc_html__( 'Yes', 'boxcar' ),
            ]
        );

        $repeater->add_control(
            'text_verified',
            [
                'label' => esc_html__( 'Text Verified', 'boxcar' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Verified',
                'condition' => [
                    'verified' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Link To', 'boxcar' ),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__( 'Enter your social link here', 'boxcar' ),
                'placeholder' => esc_html__( 'https://your-link.com', 'boxcar' ),
            ]
        );

        $this->add_control(
            'testimonials',
            [
                'label' => esc_html__( 'Testimonials', 'boxcar' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'boxcar' ),
                'type' => Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 3,
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label' => esc_html__( 'Show Nav', 'boxcar' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'boxcar' ),
                'label_off' => esc_html__( 'Show', 'boxcar' ),
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__( 'Show Pagination', 'boxcar' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'boxcar' ),
                'label_off' => esc_html__( 'Show', 'boxcar' ),
            ]
        );

        $this->add_control(
            'fullscreen',
            [
                'label'         => esc_html__( 'Full Screen', 'boxcar' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout', 'boxcar' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'style1' => esc_html__('Style 1', 'boxcar'),
                    'style2' => esc_html__('Style 2', 'boxcar'),
                    'style3' => esc_html__('Style 3', 'boxcar'),
                    'style4' => esc_html__('Style 4', 'boxcar'),
                    'style5' => esc_html__('Style 5', 'boxcar'),
                ),
                'default' => 'style1'
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_box_style',
            [
                'label' => esc_html__( 'Style Box', 'boxcar' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'boxcar' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} [class *="testimonials-item"]' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Style Info', 'boxcar' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Quote Color', 'boxcar' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon-quote' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'boxcar' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Title Typography', 'boxcar' ),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .widget-title',
            ]
        );

        $this->add_control(
            'test_title_color',
            [
                'label' => esc_html__( 'Testimonial Title Color', 'boxcar' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .name-client' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .name-client a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Testimonial Title Typography', 'boxcar' ),
                'name' => 'test_title_typography',
                'selector' => '{{WRAPPER}} .name-client',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__( 'Content Color', 'boxcar' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Content Typography', 'boxcar' ),
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .description',
            ]
        );

        $this->add_control(
            'listing_color',
            [
                'label' => esc_html__( 'Listing Color', 'boxcar' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .listing' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Listing Typography', 'boxcar' ),
                'name' => 'listing_typography',
                'selector' => '{{WRAPPER}} .listing',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings();

        extract( $settings );

        $columns = !empty($columns) ? $columns : 3;
        $columns_tablet = !empty($columns_tablet) ? $columns_tablet : 2;
        $columns_mobile = !empty($columns_mobile) ? $columns_mobile : 1;
        
        $slides_to_scroll = !empty($slides_to_scroll) ? $slides_to_scroll : 1;
        $slides_to_scroll_tablet = !empty($slides_to_scroll_tablet) ? $slides_to_scroll_tablet : $columns_tablet;
        $slides_to_scroll_mobile = !empty($slides_to_scroll_mobile) ? $slides_to_scroll_mobile : $columns_mobile;

        if ( !empty($testimonials) ) {
            ?>
            <div class="widget-testimonials <?php echo esc_attr($el_class.' '.$layout_type); ?>">
                <?php
                if ($layout_type == 'style6' ) {
                    ?>
                    
                    <div class="slick-carousel testimonial-main <?php echo esc_attr( $fullscreen ? 'fullscreen' : 'nofullscreen' ); ?>" data-items="1" data-smallmedium="1" data-extrasmall="1" data-pagination="false" data-nav="false" data-asnavfor=".testimonial-thumbnail" data-slickparent="true">
                        <?php foreach ($testimonials as $item) { ?>
                            <?php $img_src = ( isset( $item['img_src']['id'] ) && $item['img_src']['id'] != 0 ) ? wp_get_attachment_url( $item['img_src']['id'] ) : ''; ?>
                            <div class="item">
                                <div class="testimonials-item <?php echo esc_attr( $layout_type ); ?>">
                                    <?php if ( !empty($item['content']) ) { ?>
                                        <div class="description"><?php echo trim($item['content']); ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="wrapper-testimonial-thumbnail">
                        <div class="slick-carousel testimonial-thumbnail" data-centerMode="true" data-items="3" data-smallmedium="3" data-extrasmall="1" data-pagination="false" data-nav="false" data-asnavfor=".testimonial-main" data-slidestoscroll="1" data-focusonselect="true" data-infinite="true">
                            <?php foreach ($testimonials as $item) { ?>
                                <?php $img_src = ( isset( $item['img_src']['id'] ) && $item['img_src']['id'] != 0 ) ? wp_get_attachment_url( $item['img_src']['id'] ) : ''; ?>
                                <div class="item">
                                    <div class="testimonials-item <?php echo esc_attr( $layout_type ); ?>">
                                        <div class="bottom-info flex-middle">

                                            <?php if ( $img_src ) { ?>
                                                <div class="wrapper-avarta">
                                                    <div class="avarta">
                                                        <img src="<?php echo esc_url($img_src); ?>" alt="<?php echo (!empty($item['name']) ? esc_attr($item['name']) : ''); ?>">
                                                    </div>
                                                </div>
                                            <?php } ?>

                                            <div class="info-testimonials">
                                                <?php if ( !empty($item['name']) ) {

                                                    $title = '<h3 class="name-client">'.esc_html($item['name']).'</h3>';
                                                    if ( ! empty( $item['link']['url'] ) ) {
                                                        $title = sprintf( '<h3 class="name-client"><a href="'.esc_url($item['link']['url']).'" target="'.esc_attr($item['link']['is_external'] ? '_blank' : '_self').'" '.($item['link']['nofollow'] ? 'rel="nofollow"' : '').'>%1$s</a></h3>', esc_html($item['name']) );
                                                    }
                                                    echo trim($title);
                                                ?>
                                                <?php } ?>
                                                <?php if ( !empty($item['listing']) ) { ?>
                                                    <div class="listing"><?php echo esc_html($item['listing']); ?></div>
                                                <?php } ?> 
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>

                <?php } elseif ( $layout_type == 'style1' ) { ?>
                    <div class="slick-carousel testimonial-main <?php echo esc_attr( $fullscreen ? 'fullscreen' : 'nofullscreen' ); ?> <?php echo trim( ($columns >= count($testimonials))?'hidden-dots':'' ); ?>" 
                        data-items="<?php echo esc_attr($columns); ?>"
                        data-large="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-medium="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-small="<?php echo esc_attr($columns_mobile); ?>"
                        data-smallest="<?php echo esc_attr($columns_mobile); ?>"

                        data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                        data-slidestoscroll_large="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_medium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_small="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-slidestoscroll_smallest="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>">
                        <?php foreach ($testimonials as $item) { ?>
                        <div class="item">
                            <div class="testimonials-item <?php echo esc_attr( $layout_type ); ?> d-flex align-items-center">
                                
                                <?php if ( isset( $item['img_src']['id'] ) ) { ?>
                                    <div class="avarta flex-shrink-0">
                                        <?php echo boxcar_get_attachment_thumbnail($item['img_src']['id'], 'full'); ?>
                                    </div>
                                <?php } ?>
                                <div class="right-info flex-grow-1">
                                    <div class="info-testimonials">
                                        <?php if ( !empty($item['star']) ) { ?>
                                            <div class="star d-flex align-items-center">
                                                <div class="inner">
                                                    <div class="w-percent" style="width: <?php echo esc_attr($item['star']*20)?>%;"></div>
                                                </div>
                                                <span class="text"><?php echo number_format($item['star'], 1, '.', ''); ?> </span>
                                            </div>
                                        <?php } ?>
                                        <?php if ( !empty($item['name']) ) {

                                            $title = '<h3 class="name-client">'.esc_html($item['name']).'</h3>';
                                            if ( ! empty( $item['link']['url'] ) ) {
                                                $title = sprintf( '<h3 class="name-client"><a href="'.esc_url($item['link']['url']).'" target="'.esc_attr($item['link']['is_external'] ? '_blank' : '_self').'" '.($item['link']['nofollow'] ? 'rel="nofollow"' : '').'>%1$s</a></h3>', esc_html($item['name']) );
                                            }
                                            echo trim($title);
                                        ?>
                                        <?php } ?>
                                        <?php if ( !empty($item['listing']) ) { ?>
                                            <div class="listing"><?php echo esc_html($item['listing']); ?></div>
                                        <?php } ?> 
                                    </div>
                                    
                                    <?php if ( !empty($item['content']) ) { ?>
                                        <div class="description"><?php echo trim($item['content']); ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>

                <?php } elseif ( $layout_type == 'style2' ) { ?>
                    <div class="slick-carousel testimonial-main <?php echo esc_attr( $fullscreen ? 'fullscreen' : 'nofullscreen' ); ?> <?php echo esc_attr( ($columns >= count($testimonials))?'hidden-dots':'' ); ?>" 
                        data-items="<?php echo esc_attr($columns); ?>"
                        data-large="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-medium="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-small="<?php echo esc_attr($columns_mobile); ?>"
                        data-smallest="<?php echo esc_attr($columns_mobile); ?>"

                        data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                        data-slidestoscroll_large="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_medium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_small="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-slidestoscroll_smallest="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>">
                        <?php foreach ($testimonials as $item) { ?>
                        <div class="item">
                            <div class="testimonials-item2">
                                <?php if ( isset( $item['img_src']['id'] ) ) { ?>
                                    <div class="wrapper-avarta">
                                        <div class="avarta">
                                            <?php echo boxcar_get_attachment_thumbnail($item['img_src']['id'], 'full'); ?>
                                        </div>
                                    </div>
                                <?php } ?>

                                <div class="wrapper-star d-flex align-items-center">
                                    <?php if ( !empty($item['star']) ) { ?>
                                        <div class="star2 position-relative">
                                            <div class="d-flex item-star align-items-center">
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                            </div>
                                            <div class="w-percent-active d-flex item-star align-items-center" style="width: <?php echo esc_attr($item['star']*20)?>%;">
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                            </div>
                                        </div>
                                    <?php } ?>

                                    <?php if(!empty($item['verified'])) { ?>
                                        <span class="verified">
                                            <span class="icon-verified fa fa-check"></span><?php echo esc_html($item['text_verified']); ?>
                                        </span>
                                    <?php } ?>
                                </div>

                                <?php if ( !empty($item['listing']) ) { ?>
                                    <div class="listing"><?php echo esc_html($item['listing']); ?></div>
                                <?php } ?> 
                                <?php if ( !empty($item['content']) ) { ?>
                                    <div class="description"><?php echo trim($item['content']); ?></div>
                                <?php } ?>
                                <?php if ( !empty($item['name']) ) {
                                    $title = '<h3 class="name-client">'.$item['name'].'</h3>';
                                    if ( ! empty( $item['link']['url'] ) ) {
                                        $title = sprintf( '<h3 class="name-client"><a href="'.esc_url($item['link']['url']).'" target="'.esc_attr($item['link']['is_external'] ? '_blank' : '_self').'" '.($item['link']['nofollow'] ? 'rel="nofollow"' : '').'>%1$s</a></h3>', $item['name'] );
                                    }
                                    echo trim($title);
                                ?>
                                <?php } ?>
                                
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                    
                <?php } elseif ( $layout_type == 'style3') { ?>
                    <div class="slick-carousel testimonial-main <?php echo esc_attr( $fullscreen ? 'fullscreen' : 'nofullscreen' ); ?>"
                        data-items="<?php echo esc_attr($columns); ?>"
                        data-large="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-medium="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-small="<?php echo esc_attr($columns_mobile); ?>"
                        data-smallest="<?php echo esc_attr($columns_mobile); ?>"

                        data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                        data-slidestoscroll_large="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_medium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_small="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-slidestoscroll_smallest="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>" data-asnavfor=".testimonial-thumbnail" data-slickparent="true">
                        <?php foreach ($testimonials as $item) { ?>
                            <?php $img_src = ( isset( $item['img_src']['id'] ) && $item['img_src']['id'] != 0 ) ? wp_get_attachment_url( $item['img_src']['id'] ) : ''; ?>
                            <div class="item">
                                <div class="testimonials-item3">
                                    <?php if ( !empty($item['star']) || !empty($item['verified']) ) { ?>
                                        <div class="wrapper-star d-flex align-items-center">
                                            <?php if ( !empty($item['star']) ) { ?>
                                                <div class="star2 position-relative">
                                                    <div class="d-flex item-star align-items-center">
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                    </div>
                                                    <div class="w-percent-active d-flex item-star align-items-center" style="width: <?php echo esc_attr($item['star']*20)?>%;">
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                        <span class="star"><i class="fas fa-star"></i></span>
                                                    </div>
                                                </div>
                                            <?php } ?>

                                            <?php if(!empty($item['verified'])) { ?>
                                                <span class="verified">
                                                    <span class="icon-verified fa fa-check"></span><?php echo esc_html($item['text_verified']); ?>
                                                </span>
                                            <?php } ?>
                                        </div>
                                    <?php } ?>
                                    <div class="info-testimonials">
                                        <?php if ( !empty($item['name']) ) {

                                            $title = '<h3 class="name-client">'.$item['name'].'</h3>';
                                            if ( ! empty( $item['link']['url'] ) ) {
                                                $title = sprintf( '<h3 class="name-client"><a href="'.esc_url($item['link']['url']).'" target="'.esc_attr($item['link']['is_external'] ? '_blank' : '_self').'" '.($item['link']['nofollow'] ? 'rel="nofollow"' : '').'>%1$s</a></h3>', $item['name'] );
                                            }
                                            echo trim($title);
                                        ?>
                                        <?php } ?>
                                        <?php if ( !empty($item['listing']) ) { ?>
                                            <div class="listing"><?php echo esc_html($item['listing']); ?></div>
                                        <?php } ?> 
                                    </div>
                                    <?php if ( !empty($item['content']) ) { ?>
                                        <div class="description"><?php echo trim($item['content']); ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="wrapper-testimonial-thumbnail">
                        <div class="slick-carousel testimonial-thumbnail" data-items="9" data-large="8" data-medium="7" data-small="6" data-smallest="5" data-pagination="false" data-nav="false" data-asnavfor=".testimonial-main" data-slidestoscroll="1" data-focusonselect="true">
                            <?php foreach ($testimonials as $item) { ?>
                                <?php $img_src = ( isset( $item['img_src']['id'] ) && $item['img_src']['id'] != 0 ) ? wp_get_attachment_url( $item['img_src']['id'] ) : ''; ?>
                                <div class="item">
                                    <div class="testimonials-item-bottom-3">
                                        <?php if ( $img_src ) { ?>
                                            <div class="wrapper-avarta">
                                                <div class="avarta">
                                                    <?php echo wp_get_attachment_image( $item['img_src']['id'], 'thumbnail' );  ?>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                <?php } elseif ( $layout_type == 'style4' ) { ?>
                    <div class="slick-carousel testimonial-main <?php echo esc_attr( $fullscreen ? 'fullscreen' : 'nofullscreen' ); ?> <?php echo esc_attr( ($columns >= count($testimonials))?'hidden-dots':'' ); ?>" 
                        data-items="<?php echo esc_attr($columns); ?>"
                        data-large="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-medium="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-small="<?php echo esc_attr($columns_mobile); ?>"
                        data-smallest="<?php echo esc_attr($columns_mobile); ?>"

                        data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                        data-slidestoscroll_large="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_medium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_small="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-slidestoscroll_smallest="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>">
                        <?php foreach ($testimonials as $item) { ?>
                        <div class="item">
                            <div class="testimonials-item4">
                                <?php if ( isset( $item['img_src']['id'] ) ) { ?>
                                    <div class="wrapper-avarta">
                                        <div class="avarta">
                                            <?php echo boxcar_get_attachment_thumbnail($item['img_src']['id'], 'full'); ?>
                                        </div>
                                    </div>
                                <?php } ?>

                                <div class="wrapper-star d-flex align-items-center">
                                    <?php if ( !empty($item['star']) ) { ?>
                                        <div class="star2 position-relative">
                                            <div class="d-flex item-star align-items-center">
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                            </div>
                                            <div class="w-percent-active d-flex item-star align-items-center" style="width: <?php echo esc_attr($item['star']*20)?>%;">
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                                <span class="star"><i class="fas fa-star"></i></span>
                                            </div>
                                        </div>
                                    <?php } ?>

                                    <?php if(!empty($item['verified'])) { ?>
                                        <span class="verified">
                                            <span class="icon-verified fa fa-check"></span><?php echo esc_html($item['text_verified']); ?>
                                        </span>
                                    <?php } ?>
                                </div>

                                <?php if ( !empty($item['listing']) ) { ?>
                                    <div class="listing"><?php echo esc_html($item['listing']); ?></div>
                                <?php } ?> 
                                <?php if ( !empty($item['content']) ) { ?>
                                    <div class="description"><?php echo trim($item['content']); ?></div>
                                <?php } ?>
                                <?php if ( !empty($item['name']) ) {
                                    $title = '<h3 class="name-client">'.$item['name'].'</h3>';
                                    if ( ! empty( $item['link']['url'] ) ) {
                                        $title = sprintf( '<h3 class="name-client"><a href="'.esc_url($item['link']['url']).'" target="'.esc_attr($item['link']['is_external'] ? '_blank' : '_self').'" '.($item['link']['nofollow'] ? 'rel="nofollow"' : '').'>%1$s</a></h3>', $item['name'] );
                                    }
                                    echo trim($title);
                                ?>
                                <?php } ?>
                                
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                <?php } elseif ( $layout_type == 'style5' ) { ?>
                    <div class="slick-carousel testimonial-main <?php echo esc_attr( $fullscreen ? 'fullscreen' : 'nofullscreen' ); ?> <?php echo esc_attr( ($columns >= count($testimonials))?'hidden-dots':'' ); ?>" 
                        data-items="<?php echo esc_attr($columns); ?>"
                        data-large="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-medium="<?php echo esc_attr( $columns_tablet ); ?>"
                        data-small="<?php echo esc_attr($columns_mobile); ?>"
                        data-smallest="<?php echo esc_attr($columns_mobile); ?>"

                        data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                        data-slidestoscroll_large="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_medium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                        data-slidestoscroll_small="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-slidestoscroll_smallest="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                        data-infinite="true"
                        data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>">
                        <?php foreach ($testimonials as $item) { ?>
                        <div class="item">
                            <div class="testimonials-item5">
                                
                                <div class="d-flex align-items-center">
                                    <?php if ( !empty($item['reviews']) ) { ?>
                                        <div class="reviews"><?php echo esc_html($item['reviews']); ?></div>
                                    <?php } ?> 
                                    <svg xmlns="http://www.w3.org/2000/svg" class="ms-auto icon-quote" width="37" height="26" viewBox="0 0 37 26" fill="none">
                                    <path d="M9.1 25.8C6.76667 25.8 4.66667 24.8667 2.8 23C0.933334 21.0667 0 18.2333 0 14.5C0 10.2333 1.13333 6.76666 3.4 4.1C5.73333 1.36667 9.03333 0 13.3 0C14.8333 0 16.0333 0.099998 16.9 0.299995V4.9C15.9667 4.76666 14.7667 4.7 13.3 4.7C11.0333 4.7 9.2 5.46666 7.8 7C6.46667 8.33333 5.7 10.1 5.5 12.3C6.36667 11.2333 7.76667 10.7 9.7 10.7C11.7 10.7 13.4 11.4 14.8 12.8C16.2 14.1333 16.9 15.9 16.9 18.1C16.9 20.3667 16.1667 22.2333 14.7 23.7C13.2333 25.1 11.3667 25.8 9.1 25.8ZM29 25.8C26.6667 25.8 24.5667 24.8667 22.7 23C20.8333 21.0667 19.9 18.2333 19.9 14.5C19.9 10.2333 21.0333 6.76666 23.3 4.1C25.6333 1.36667 28.9333 0 33.2 0C34.7333 0 35.9333 0.099998 36.8 0.299995V4.9C35.8667 4.76666 34.6667 4.7 33.2 4.7C30.9333 4.7 29.1 5.46666 27.7 7C26.3667 8.33333 25.6 10.1 25.4 12.3C26.2667 11.2333 27.6667 10.7 29.6 10.7C31.6 10.7 33.3 11.4 34.7 12.8C36.1 14.1333 36.8 15.9 36.8 18.1C36.8 20.3667 36.0667 22.2333 34.6 23.7C33.1333 25.1 31.2667 25.8 29 25.8Z" fill="currentColor"/>
                                    </svg>
                                </div>
                                
                                <?php if ( !empty($item['content']) ) { ?>
                                    <div class="description"><?php echo trim($item['content']); ?></div>
                                <?php } ?>

                                <div class="d-flex align-items-center info">
                                    <?php if ( isset( $item['img_src']['id'] ) ) { ?>
                                        <div class="wrapper-avarta">
                                            <div class="avarta">
                                                <?php echo boxcar_get_attachment_thumbnail($item['img_src']['id'], 'thumbnail'); ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                    <div class="inner-info">
                                        <?php if ( !empty($item['name']) ) {
                                            $title = '<h3 class="name-client">'.$item['name'].'</h3>';
                                            if ( ! empty( $item['link']['url'] ) ) {
                                                $title = sprintf( '<h3 class="name-client"><a href="'.esc_url($item['link']['url']).'" target="'.esc_attr($item['link']['is_external'] ? '_blank' : '_self').'" '.($item['link']['nofollow'] ? 'rel="nofollow"' : '').'>%1$s</a></h3>', $item['name'] );
                                            }
                                            echo trim($title);
                                        ?>
                                        <?php } ?>
                                        <?php if ( !empty($item['listing']) ) { ?>
                                            <div class="listing"><?php echo esc_html($item['listing']); ?></div>
                                        <?php } ?> 
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
            <?php
        }
    }
}

Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Testimonials );
