<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_Team extends Widget_Base {

    public function get_name() {
        return 'apus_element_team';
    }

    public function get_title() {
        return esc_html__( 'Apus Teams', 'boxcar' );
    }

    public function get_icon() {
        return 'fa fa-users';
    }

    public function get_categories() {
        return [ 'boxcar-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Team', 'boxcar' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'name', [
                'label' => esc_html__( 'Name', 'boxcar' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Name' , 'boxcar' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'listing', [
                'label' => esc_html__( 'Job', 'boxcar' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Job' , 'boxcar' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'email', [
                'label' => esc_html__( 'Email', 'boxcar' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'email' , 'boxcar' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'phone', [
                'label' => esc_html__( 'Phone', 'boxcar' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'phone' , 'boxcar' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'img_src',
            [
                'name' => 'image',
                'label' => esc_html__( 'Image', 'boxcar' ),
                'type' => Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Here', 'boxcar' ),
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'boxcar' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Style 1', 'boxcar'),
                    'style_2' => esc_html__('Style 2', 'boxcar'),
                ),
                'default' => ''
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Title', 'boxcar' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Background Hover Color', 'boxcar' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Core\Schemes\Color::get_type(),
                    'value' => Core\Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .social a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings();

        extract( $settings );

        ?>
        <div class="widget-team <?php echo esc_attr($el_class.' '.$style); ?>">
            <?php
            if ( !empty($settings['img_src']['id']) ) {
            ?>
                <div class="team-image position-relative">
                    <?php echo boxcar_get_attachment_thumbnail($settings['img_src']['id'], 'full'); ?>
                    <div class="inner">
                        <?php if ( !empty($email) ) { ?>
                            <div class="email"><?php echo esc_html($email); ?></div>
                        <?php } ?>
                        <?php if ( !empty($phone) ) { ?>
                            <div class="phone"><?php echo esc_html($phone); ?></div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
                
            <div class="content">
                <?php if ( !empty($name) ) { ?>
                    <h3 class="name-team"><?php echo esc_html($name); ?></h3>
                <?php } ?>
                <?php if ( !empty($listing) ) { ?>
                    <div class="listing"><?php echo esc_html($listing); ?></div>
                <?php } ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Team );
