<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_Popup_Video extends Widget_Base {

	public function get_name() {
        return 'apus_element_popup_video';
    }

	public function get_title() {
        return esc_html__( 'Apus Popup Video', 'boxcar' );
    }

	public function get_icon() {
        return 'eicon-youtube';
    }

	public function get_categories() {
        return [ 'boxcar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'boxcar' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'video_link',
            [
                'label' => esc_html__( 'Youtube Video Link', 'boxcar' ),
                'type' => Controls_Manager::TEXT,
                'input_type' => 'url',
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings();

        extract( $settings );

        ?>
                <a class="popup-video d-flex align-items-center justify-content-center position-relative <?php echo esc_attr($el_class);?>" href="<?php echo esc_url($video_link); ?>">
                    <span class="popup-video-inner">
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="24" viewBox="0 0 22 24" fill="none">
<path d="M20.1629 9.58241L3.97562 0.369568C2.25854 -0.610709 0.507935 0.461369 0.507935 2.38919V21.6219C0.507935 23.2552 1.57123 24 2.55949 24C3.02488 24 3.49905 23.8531 3.97003 23.5665L20.23 13.6137C21.0474 13.1116 21.5064 12.3684 21.4921 11.5741C21.4785 10.779 20.9947 10.0526 20.1629 9.58241ZM19.1404 11.8359L2.88119 21.7864C2.77183 21.8534 2.68562 21.8869 2.62654 21.9037C2.61058 21.8446 2.59461 21.7536 2.59461 21.6219V2.38999C2.59461 2.19202 2.63054 2.09223 2.63054 2.06749C2.6944 2.07148 2.80615 2.10421 2.94665 2.18404L19.1316 11.3969C19.3312 11.511 19.3902 11.61 19.4094 11.5885C19.399 11.6156 19.3312 11.717 19.1404 11.8359Z" fill="currentColor"/>
</svg>
                    </span>
                </a>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Popup_Video );
