<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_Nav_Bar extends Elementor\Widget_Base {

    public function get_name() {
        return 'apus_element_nav_bar';
    }

    public function get_title() {
        return esc_html__( 'Apus Header NavBar', 'boxcar' );
    }
    
    public function get_categories() {
        return [ 'boxcar-header-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $custom_menus = array();
        $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
        if ( is_array( $menus ) && ! empty( $menus ) ) {
            foreach ( $menus as $menu ) {
                if ( is_object( $menu ) && isset( $menu->name, $menu->slug ) ) {
                    $custom_menus[ $menu->slug ] = $menu->name;
                }
            }
        }

        $this->add_control(
            'nav_menu',
            [
                'label' => esc_html__( 'Menu', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $custom_menus,
                'default' => ''
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => esc_html__( 'Enter your title here', 'boxcar' ),
            ]
        );
        
        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => esc_html__( 'Icon', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .show-navbar-sidebar' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_hv_color',
            [
                'label' => esc_html__( 'Hover Color', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .show-navbar-sidebar:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings();

        extract( $settings );

        $menu_id = 0;
        if ($nav_menu) {
            $term = get_term_by( 'slug', $nav_menu, 'nav_menu' );
            if ( !empty($term) ) {
                $menu_id = $term->term_id;
            }
        }

        if ( !empty($menu_id) ) {
        ?>
            <div class="vertical-wrapper <?php echo esc_attr($el_class); ?>">
                <span class="show-navbar-sidebar d-inline-flex align-items-center">
                    <i class="vertical-icon pre"></i>
                    <?php if ( $title ) { ?>
                        <span class="text"><?php echo esc_html($title); ?></span>
                    <?php } ?>
                </span>
                <div class="vertical-menu-container-wrapper navbar-offcanvas">
                    <div class="d-flex align-items-center top-info">
                        <h3 class="title"><?php echo esc_html__('Main Menu','boxcar') ?></h3>
                        <div class="ms-auto">
                            <a class="close-action" data-toggle="offcanvas">
                                <i class="ti-close"></i>
                            </a>
                        </div>
                    </div>
                    <?php
                        $args = array(
                            'container_class' => 'content-vertical',
                            'container_id' => 'vertical-menu-container',
                            'fallback_cb' => '',
                            'menu'        => $menu_id,
                            'menu_id' => 'vertical-menu',
                            'walker' => new Boxcar_Mobile_Menu()
                        );
                        wp_nav_menu($args);
                    ?>
                </div>
                <div class="over-dark"></div>
            </div>
            <?php
            
        }
    }
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Nav_Bar );
