<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists( 'Boxcar_Elementor_Extensions' ) ) {
    final class Boxcar_Elementor_Extensions {

        private static $_instance = null;

        
        public function __construct() {
            add_action( 'elementor/elements/categories_registered', array( $this, 'add_widget_categories' ) );
            add_action( 'init', array( $this, 'elementor_widgets' ),  100 );
            add_filter( 'boxcar_generate_post_builder', array( $this, 'render_post_builder' ), 10, 3 );

            add_filter( 'elementor/icons_manager/additional_tabs', array( $this, 'custom_icons' ) );  

            add_filter( 'elementor/controls/animations/additional_animations', array( $this, 'additional_animations' ), 10 );
        }

        public static function instance () {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }
        
        public function add_widget_categories( $elements_manager ) {
            $elements_manager->add_category(
                'boxcar-elements',
                [
                    'title' => esc_html__( 'Boxcar Elements', 'boxcar' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

            $elements_manager->add_category(
                'boxcar-header-elements',
                [
                    'title' => esc_html__( 'Boxcar Header Elements', 'boxcar' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

            $elements_manager->add_category(
                'boxcar-listing-detail-elements',
                [
                    'title' => esc_html__( 'Listing Detail Elements', 'boxcar' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

            $elements_manager->add_category(
                'boxcar-listing-archive-elements',
                [
                    'title' => esc_html__( 'Listing Archive Elements', 'boxcar' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

            $elements_manager->add_category(
                'boxcar-user-detail-elements',
                [
                    'title' => esc_html__( 'User Detail Elements', 'boxcar' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

            $elements_manager->add_category(
                'boxcar-dashboard-elements',
                [
                    'title' => esc_html__( 'Dashboard Elements', 'boxcar' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

            $elements_manager->add_category(
                'boxcar-dealer-detail-elements',
                [
                    'title' => esc_html__( 'Dealer Detail Elements', 'boxcar' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

            $elements_manager->add_category(
                'boxcar-dealer-archive-elements',
                [
                    'title' => esc_html__( 'Dealer Archive Elements', 'boxcar' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );
        }

        public function elementor_widgets() {
            // general elements
            get_template_part( 'inc/vendors/elementor/widgets/heading' );
            get_template_part( 'inc/vendors/elementor/widgets/posts' );
            get_template_part( 'inc/vendors/elementor/widgets/call_to_action' );
            get_template_part( 'inc/vendors/elementor/widgets/features_box' );
            get_template_part( 'inc/vendors/elementor/widgets/address_box' );
            get_template_part( 'inc/vendors/elementor/widgets/social_links' );
            get_template_part( 'inc/vendors/elementor/widgets/testimonials' );
            get_template_part( 'inc/vendors/elementor/widgets/brands' );
            get_template_part( 'inc/vendors/elementor/widgets/popup_video' );
            get_template_part( 'inc/vendors/elementor/widgets/banner' );
            get_template_part( 'inc/vendors/elementor/widgets/banner_account' );
            get_template_part( 'inc/vendors/elementor/widgets/countdown' );
            get_template_part( 'inc/vendors/elementor/widgets/nav_menu' );
            get_template_part( 'inc/vendors/elementor/widgets/team' );
            get_template_part( 'inc/vendors/elementor/widgets/achievements' );
            get_template_part( 'inc/vendors/elementor/widgets/list_icon' );
            get_template_part( 'inc/vendors/elementor/widgets/tabs' );
            get_template_part( 'inc/vendors/elementor/widgets/elementor-template' );

            // header elements
            get_template_part( 'inc/vendors/elementor/header-widgets/logo' );
            get_template_part( 'inc/vendors/elementor/header-widgets/primary_menu' );
            get_template_part( 'inc/vendors/elementor/header-widgets/nav_bar' );
            

            if ( boxcar_is_mailchimp_activated() ) {
                get_template_part( 'inc/vendors/elementor/widgets/mailchimp' );
            }
            
            if ( boxcar_is_revslider_activated() ) {
                get_template_part( 'inc/vendors/elementor/widgets/revslider' );
            }

            if ( boxcar_is_wp_cardealer_activated() ) {
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/listings' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/listings-tabs' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/listings-slider' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/listings-slider-special' );

                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/type-banner' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/listings-types' );

                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/search-form' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/search-form-tabs' );

                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-info' );

                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/compare-btn' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/favorite-btn' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/submit-btn' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/currencies' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/mortgage-calculator' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/login-register-form-tabs' );

                // Listing detail page
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-breadcrumbs' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-title' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-tagline' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-share-button' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-favorite-button' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-compare-button' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-price' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-single-field' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-gallery' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-overview' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-description' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-features' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-location' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-reviews' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-attachments' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-related' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-contact-form' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/detail-author-info' );

                // Listing Archive
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/archive-page-title' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/archive-results-count' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/archive-sortby' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/archive-listing-items' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/archive-pagination' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/archive-maps' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/archive-tax-description' );
                
                // User Detail
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-title' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-avatar' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-single-field' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-view-cars-btn' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-description' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-maps' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-listings' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-message-button' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/user-hours' );

                // Dashboard
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dashboard-listing-count' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dashboard-review-count' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dashboard-favorite-count' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dashboard-message-count' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dashboard-chart' );
                get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dashboard-activities' );

                if ( version_compare(WP_CARDEALER_PLUGIN_VERSION, '1.2.0', '>=') ) {
                    // Dealer Archive
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-archive-page-title' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-archive-listing-items' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-archive-pagination' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-archive-results-count' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-archive-sortby' );

                    // Dealer Single
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-featured-image' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-title' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-tagline' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-description' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-listings-btn' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-single-field' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-contact-form' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-gallery' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-location' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-listings' );
                    
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-hours' );
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-detail-reviews' );
                    
                    get_template_part( 'inc/vendors/elementor/wp-cardealer-widgets/dealer/dealer-search-form' );
                }
            }

            if ( boxcar_is_wp_cardealer_wc_paid_listings_activated() && boxcar_is_woocommerce_activated() ) {
                get_template_part( 'inc/vendors/elementor/wc-paid-listings-widgets/packages' );
                get_template_part( 'inc/vendors/elementor/wc-paid-listings-widgets/user_packages' );
                get_template_part( 'inc/vendors/elementor/wc-paid-listings-widgets/transactions' );
            }
        }


        public function custom_icons($icons_args = array()) {
            $flaticon_icons = array(
                'flaticon-user', 'flaticon-search', 'flaticon-arrow-down-sign-to-navigate', 'flaticon-bookmark', 'flaticon-gearbox', 'flaticon-speedometer', 'flaticon-gasoline-pump', 'flaticon-arrow-point-to-right', 'flaticon-arrowhead-thin-outline-to-the-left', 'flaticon-car', 'flaticon-eco-car', 'flaticon-car-1', 'flaticon-convertible-car', 'flaticon-electric-car-1', 'flaticon-calendar', 'flaticon-smartphone', 'flaticon-email', 'flaticon-van', 'flaticon-pick-up-truck', 'flaticon-electric-car-2', 'flaticon-calendar-1', 'flaticon-filter', 'flaticon-cancel', 'flaticon-upload', 'flaticon-pin', 'flaticon-steering-wheel', 'flaticon-brochure', 'flaticon-report', 'flaticon-price-tag-2', 'flaticon-car-2', 'flaticon-wheel', 'flaticon-avatar', 'flaticon-engine', 'flaticon-car-door', 'flaticon-piston', 'flaticon-fill', 'flaticon-play-button', 'flaticon-degrees', 'flaticon-camera', 'flaticon-dashboard', 'flaticon-home', 'flaticon-chat', 'flaticon-photo', 'flaticon-logout', 'flaticon-search-1', 'flaticon-car-3', 'flaticon-insurance', 'flaticon-commit-git', 'flaticon-basket'
            );

            $icons_args['apus-flaticon-icon'] = array(
                'name'          => 'apus-flaticon-icon',
                'label'         => esc_html__( 'Flaticon Icon', 'boxcar' ),
                'labelIcon'     => 'fas fa-user',
                'prefix'        => '',
                'displayPrefix' => '',
                'url'           => get_template_directory_uri() . '/css/flaticon.css',
                'icons'         => $flaticon_icons,
                'ver'           => BOXCAR_THEME_VERSION,
            );

            $themify_icons = array(
                'ti-volume', 'ti-user', 'ti-unlock', 'ti-unlink', 'ti-trash', 'ti-thought', 'ti-target', 'ti-tag', 'ti-tablet', 'ti-star', 'ti-spray', 'ti-signal', 'ti-shopping-cart', 'ti-shopping-cart-full', 'ti-settings', 'ti-search', 'ti-zoom-in', 'ti-zoom-out', 'ti-cut', 'ti-ruler', 'ti-ruler-pencil', 'ti-ruler-alt', 'ti-bookmark', 'ti-bookmark-alt', 'ti-reload', 'ti-plus', 'ti-pin', 'ti-pencil', 'ti-pencil-alt', 'ti-paint-roller', 'ti-paint-bucket', 'ti-na', 'ti-mobile', 'ti-minus', 'ti-medall', 'ti-medall-alt', 'ti-marker', 'ti-marker-alt', 'ti-arrow-up', 'ti-arrow-right', 'ti-arrow-left', 'ti-arrow-down', 'ti-lock', 'ti-location-arrow', 'ti-link', 'ti-layout', 'ti-layers', 'ti-layers-alt', 'ti-key', 'ti-import', 'ti-image', 'ti-heart', 'ti-heart-broken', 'ti-hand-stop', 'ti-hand-open', 'ti-hand-drag', 'ti-folder', 'ti-flag', 'ti-flag-alt', 'ti-flag-alt-2', 'ti-eye', 'ti-export', 'ti-exchange-vertical', 'ti-desktop', 'ti-cup', 'ti-crown', 'ti-comments', 'ti-comment', 'ti-comment-alt', 'ti-close', 'ti-clip', 'ti-angle-up', 'ti-angle-right', 'ti-angle-left', 'ti-angle-down', 'ti-check', 'ti-check-box', 'ti-camera', 'ti-announcement', 'ti-brush', 'ti-briefcase', 'ti-bolt', 'ti-bolt-alt', 'ti-blackboard', 'ti-bag', 'ti-move', 'ti-arrows-vertical', 'ti-arrows-horizontal', 'ti-fullscreen', 'ti-arrow-top-right', 'ti-arrow-top-left', 'ti-arrow-circle-up', 'ti-arrow-circle-right', 'ti-arrow-circle-left', 'ti-arrow-circle-down', 'ti-angle-double-up', 'ti-angle-double-right', 'ti-angle-double-left', 'ti-angle-double-down', 'ti-zip', 'ti-world', 'ti-wheelchair', 'ti-view-list', 'ti-view-list-alt', 'ti-view-grid', 'ti-uppercase', 'ti-upload', 'ti-underline', 'ti-truck', 'ti-timer', 'ti-ticket', 'ti-thumb-up', 'ti-thumb-down', 'ti-text', 'ti-stats-up', 'ti-stats-down', 'ti-split-v', 'ti-split-h', 'ti-smallcap', 'ti-shine', 'ti-shift-right', 'ti-shift-left', 'ti-shield', 'ti-notepad', 'ti-server', 'ti-quote-right', 'ti-quote-left', 'ti-pulse', 'ti-printer', 'ti-power-off', 'ti-plug', 'ti-pie-chart', 'ti-paragraph', 'ti-panel', 'ti-package', 'ti-music', 'ti-music-alt', 'ti-mouse', 'ti-mouse-alt', 'ti-money', 'ti-microphone', 'ti-menu', 'ti-menu-alt', 'ti-map', 'ti-map-alt', 'ti-loop', 'ti-location-pin', 'ti-list', 'ti-light-bulb', 'ti-talic', 'ti-info', 'ti-infinite', 'ti-id-badge', 'ti-hummer', 'ti-home', 'ti-help', 'ti-headphone', 'ti-harddrives', 'ti-harddrive', 'ti-gift', 'ti-game', 'ti-filter', 'ti-files', 'ti-file', 'ti-eraser', 'ti-envelope', 'ti-download', 'ti-direction', 'ti-direction-alt', 'ti-dashboard', 'ti-control-stop', 'ti-control-shuffle', 'ti-control-play', 'ti-control-pause', 'ti-control-forward', 'ti-control-backward', 'ti-cloud', 'ti-cloud-up', 'ti-cloud-down', 'ti-clipboard', 'ti-car', 'ti-calendar', 'ti-book', 'ti-bell', 'ti-basketball', 'ti-bar-chart', 'ti-bar-chart-alt', 'ti-back-right', 'ti-back-left', 'ti-arrows-corner', 'ti-archive', 'ti-anchor', 'ti-align-right', 'ti-align-left', 'ti-align-justify', 'ti-align-center', 'ti-alert', 'ti-alarm-clock', 'ti-agenda', 'ti-write', 'ti-window', 'ti-widgetized', 'ti-widget', 'ti-widget-alt', 'ti-wallet', 'ti-video-clapper', 'ti-video-camera', 'ti-vector', 'ti-themify-logo', 'ti-themify-favicon', 'ti-themify-favicon-alt', 'ti-support', 'ti-stamp', 'ti-split-v-alt', 'ti-slice', 'ti-shortcode', 'ti-shift-right-alt', 'ti-shift-left-alt', 'ti-ruler-alt-2', 'ti-receipt', 'ti-pin2', 'ti-pin-alt', 'ti-pencil-alt2', 'ti-palette', 'ti-more', 'ti-more-alt', 'ti-microphone-alt', 'ti-magnet', 'ti-line-double', 'ti-line-dotted', 'ti-line-dashed', 'ti-layout-width-full', 'ti-layout-width-default', 'ti-layout-width-default-alt', 'ti-layout-tab', 'ti-layout-tab-window', 'ti-layout-tab-v', 'ti-layout-tab-min', 'ti-layout-slider', 'ti-layout-slider-alt', 'ti-layout-sidebar-right', 'ti-layout-sidebar-none', 'ti-layout-sidebar-left', 'ti-layout-placeholder', 'ti-layout-menu', 'ti-layout-menu-v', 'ti-layout-menu-separated', 'ti-layout-menu-full', 'ti-layout-media-right-alt', 'ti-layout-media-right', 'ti-layout-media-overlay', 'ti-layout-media-overlay-alt', 'ti-layout-media-overlay-alt-2', 'ti-layout-media-left-alt', 'ti-layout-media-left', 'ti-layout-media-center-alt', 'ti-layout-media-center', 'ti-layout-list-thumb', 'ti-layout-list-thumb-alt', 'ti-layout-list-post', 'ti-layout-list-large-image', 'ti-layout-line-solid', 'ti-layout-grid4', 'ti-layout-grid3', 'ti-layout-grid2', 'ti-layout-grid2-thumb', 'ti-layout-cta-right', 'ti-layout-cta-left', 'ti-layout-cta-center', 'ti-layout-cta-btn-right', 'ti-layout-cta-btn-left', 'ti-layout-column4', 'ti-layout-column3', 'ti-layout-column2', 'ti-layout-accordion-separated', 'ti-layout-accordion-merged', 'ti-layout-accordion-list', 'ti-ink-pen', 'ti-info-alt', 'ti-help-alt', 'ti-headphone-alt', 'ti-hand-point-up', 'ti-hand-point-right', 'ti-hand-point-left', 'ti-hand-point-down', 'ti-gallery', 'ti-face-smile', 'ti-face-sad', 'ti-credit-card', 'ti-control-skip-forward', 'ti-control-skip-backward', 'ti-control-record', 'ti-control-eject', 'ti-comments-smiley', 'ti-brush-alt', 'ti-youtube', 'ti-vimeo', 'ti-twitter', 'ti-time', 'ti-tumblr', 'ti-skype', 'ti-share', 'ti-share-alt', 'ti-rocket', 'ti-pinterest', 'ti-new-window', 'ti-microsoft', 'ti-list-ol', 'ti-linkedin', 'ti-layout-sidebar-2', 'ti-layout-grid4-alt', 'ti-layout-grid3-alt', 'ti-layout-grid2-alt', 'ti-layout-column4-alt', 'ti-layout-column3-alt', 'ti-layout-column2-alt', 'ti-instagram', 'ti-google', 'ti-github', 'ti-flickr', 'ti-facebook', 'ti-dropbox', 'ti-dribbble', 'ti-apple', 'ti-android', 'ti-save', 'ti-save-alt', 'ti-yahoo', 'ti-wordpress', 'ti-vimeo-alt', 'ti-twitter-alt', 'ti-tumblr-alt', 'ti-trello', 'ti-stack-overflow', 'ti-soundcloud', 'ti-sharethis', 'ti-sharethis-alt', 'ti-reddit', 'ti-pinterest-alt', 'ti-microsoft-alt', 'ti-linux', 'ti-jsfiddle', 'ti-joomla', 'ti-html5', 'ti-flickr-alt', 'ti-email', 'ti-drupal', 'ti-dropbox-alt', 'ti-css3', 'ti-rss', 'ti-rss-alt'
            );

            $icons_args['apus-themify-icon'] = array(
                'name'          => 'apus-themify-icon',
                'label'         => esc_html__( 'Themify Icon', 'boxcar' ),
                'labelIcon'     => 'fas fa-user',
                'prefix'        => '',
                'displayPrefix' => '',
                'url'           => get_template_directory_uri() . '/css/themify-icons.css',
                'icons'         => $themify_icons,
                'ver'           => BOXCAR_THEME_VERSION,
            );

            return $icons_args;
        }

        public function additional_animations($animations = array()) {
            $additional_animations = array(
                'ApusTheme' => [
                    'scale' => esc_html__('Scale', 'boxcar'),
                    'fancy' => esc_html__('Fancy', 'boxcar'),
                    'slide-up' => esc_html__('Slide Up', 'boxcar'),
                    'slide-left' => esc_html__('Slide Left', 'boxcar'),
                    'slide-right' => esc_html__('Slide Right', 'boxcar'),
                    'slide-down' => esc_html__('Slide Down', 'boxcar'),
                ],
            );
            return array_merge( $animations, $additional_animations );
        }

        public function render_page_content($post_id) {
            if ( class_exists( 'Elementor\Core\Files\CSS\Post' ) ) {
                $css_file = new Elementor\Core\Files\CSS\Post( $post_id );
                $css_file->enqueue();
            }

            return Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $post_id );
        }

        public function render_post_builder($html, $post, $post_id) {
            if ( !empty($post) && !empty($post_id) ) {
                return $this->render_page_content($post_id);
            }
            return $html;
        }

    }
}

if ( did_action( 'elementor/loaded' ) ) {
    // Finally initialize code
    Boxcar_Elementor_Extensions::instance();
}