<?php

if ( !function_exists( 'boxcar_page_metaboxes' ) ) {
	function boxcar_page_metaboxes(array $metaboxes) {
		global $wp_registered_sidebars;
        $sidebars = array();

        if ( !empty($wp_registered_sidebars) ) {
            foreach ($wp_registered_sidebars as $sidebar) {
                $sidebars[$sidebar['id']] = $sidebar['name'];
            }
        }
        $headers = array_merge( array('global' => esc_html__( 'Global Setting', 'boxcar' )), boxcar_get_header_layouts() );
        $footers = array_merge( array('global' => esc_html__( 'Global Setting', 'boxcar' )), boxcar_get_footer_layouts() );

		$prefix = 'apus_page_';
        
        // General
	    $fields = array(
			array(
				'name' => esc_html__( 'Select Layout', 'boxcar' ),
				'id'   => $prefix.'layout',
				'type' => 'select',
				'options' => array(
					'main' => esc_html__('Main Content Only', 'boxcar'),
					'left-main' => esc_html__('Left Sidebar - Main Content', 'boxcar'),
					'main-right' => esc_html__('Main Content - Right Sidebar', 'boxcar')
				)
			),
			array(
                'id' => $prefix.'fullwidth',
                'type' => 'select',
                'name' => esc_html__('Is Full Width?', 'boxcar'),
                'default' => 'yes',
                'options' => array(
                    'no' => esc_html__('No', 'boxcar'),
                    'yes' => esc_html__('Yes', 'boxcar')
                )
            ),
            array(
                'id' => $prefix.'left_sidebar',
                'type' => 'select',
                'name' => esc_html__('Left Sidebar', 'boxcar'),
                'options' => $sidebars
            ),
            array(
                'id' => $prefix.'right_sidebar',
                'type' => 'select',
                'name' => esc_html__('Right Sidebar', 'boxcar'),
                'options' => $sidebars
            ),
            array(
                'id' => $prefix.'show_breadcrumb',
                'type' => 'select',
                'name' => esc_html__('Show Breadcrumb?', 'boxcar'),
                'options' => array(
                    'no' => esc_html__('No', 'boxcar'),
                    'yes' => esc_html__('Yes', 'boxcar')
                ),
                'default' => 'yes',
            ),
            array(
                'id' => $prefix.'breadcrumb_color',
                'type' => 'colorpicker',
                'name' => esc_html__('Breadcrumb Background Color', 'boxcar')
            ),
            array(
                'id' => $prefix.'breadcrumb_image',
                'type' => 'file',
                'name' => esc_html__('Breadcrumb Background Image', 'boxcar')
            ),

            array(
                'id' => $prefix.'header_type',
                'type' => 'select',
                'name' => esc_html__('Header Layout Type', 'boxcar'),
                'description' => esc_html__('Choose a header for your website.', 'boxcar'),
                'options' => $headers,
                'default' => 'global'
            ),
            array(
                'id' => $prefix.'header_transparent',
                'type' => 'select',
                'name' => esc_html__('Header Transparent', 'boxcar'),
                'description' => esc_html__('Choose a header for your website.', 'boxcar'),
                'options' => array(
                    'no' => esc_html__('No', 'boxcar'),
                    'yes' => esc_html__('Yes', 'boxcar')
                ),
                'default' => 'global'
            ),
            array(
                'id' => $prefix.'header_fixed',
                'type' => 'select',
                'name' => esc_html__('Header Fixed Top', 'boxcar'),
                'description' => esc_html__('Choose a header position', 'boxcar'),
                'options' => array(
                    'no' => esc_html__('No', 'boxcar'),
                    'yes' => esc_html__('Yes', 'boxcar')
                ),
                'default' => 'no'
            ),
            array(
                'id' => $prefix.'footer_type',
                'type' => 'select',
                'name' => esc_html__('Footer Layout Type', 'boxcar'),
                'description' => esc_html__('Choose a footer for your website.', 'boxcar'),
                'options' => $footers,
                'default' => 'global'
            ),
            array(
                'id' => $prefix.'boxed',
                'type' => 'select',
                'name' => esc_html__('Boxed', 'boxcar'),
                'description' => esc_html__('Choose Boxed Page', 'boxcar'),
                'options' => array(
                    'no' => esc_html__('No', 'boxcar'),
                    'yes' => esc_html__('Yes', 'boxcar')
                ),
                'default' => 'no'
            ),
            array(
                'id' => $prefix.'extra_class',
                'type' => 'text',
                'name' => esc_html__('Extra Class', 'boxcar'),
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'boxcar')
            )
    	);
		
	    $metaboxes[$prefix . 'display_setting'] = array(
			'id'                        => $prefix . 'display_setting',
			'title'                     => esc_html__( 'Display Settings', 'boxcar' ),
			'object_types'              => array( 'page' ),
			'context'                   => 'normal',
			'priority'                  => 'high',
			'show_names'                => true,
			'fields'                    => $fields
		);

	    return $metaboxes;
	}
}
add_filter( 'cmb2_meta_boxes', 'boxcar_page_metaboxes' );

if ( !function_exists( 'boxcar_cmb2_style' ) ) {
	function boxcar_cmb2_style() {
        wp_enqueue_style( 'boxcar-cmb2-style', get_template_directory_uri() . '/inc/vendors/cmb2/assets/style.css', array(), '1.0' );
		wp_enqueue_script( 'boxcar-admin', get_template_directory_uri() . '/js/admin.js', array( 'jquery' ), '20150330', true );
	}
}
add_action( 'admin_enqueue_scripts', 'boxcar_cmb2_style' );


