<?php
if ( !function_exists ('boxcar_custom_styles') ) {
	function boxcar_custom_styles() {
		global $post;

		ob_start();	
		?>
			<?php if ( boxcar_get_config('main_color') != "" ) {
				$main_color = boxcar_get_config('main_color');
			} else {
				$main_color = '#405FF2';
			}
			if ( boxcar_get_config('second_color') != "" ) {
				$second_color = boxcar_get_config('second_color');
			} else {
				$second_color = '#050B20';
			}

			if ( boxcar_get_config('main_hover_color') != "" ) {
				$main_hover_color = boxcar_get_config('main_hover_color');
			} else {
				$main_hover_color = '#4E6CFB';
			}

			if ( boxcar_get_config('second_hover_color') != "" ) {
				$second_hover_color = boxcar_get_config('second_hover_color');
			} else {
				$second_hover_color = '#050b20cc';
			}

			if ( boxcar_get_config('text_color') != "" ) {
				$text_color = boxcar_get_config('text_color');
			} else {
				$text_color = '#050B20';
			}

			if ( boxcar_get_config('link_color') != "" ) {
				$link_color = boxcar_get_config('link_color');
			} else {
				$link_color = '#050B20';
			}

			if ( boxcar_get_config('link_hover_color') != "" ) {
				$link_hover_color = boxcar_get_config('link_hover_color');
			} else {
				$link_hover_color = '#405FF2';
			}

			if ( boxcar_get_config('heading_color') != "" ) {
				$heading_color = boxcar_get_config('heading_color');
			} else {
				$heading_color = '#050B20';
			}

			$main_color_rgb = boxcar_hex2rgb($main_color);
			$second_color_rgb = boxcar_hex2rgb($second_color);
			
			// font
			$main_font = boxcar_get_config('main-font');
			$main_font = !empty($main_font) ? json_decode($main_font, true) : array();
			$main_font_family = !empty($main_font['fontfamily']) ? $main_font['fontfamily'] : 'DM Sans';
			$main_font_weight = !empty($main_font['fontweight']) ? $main_font['fontweight'] : 400;
			$main_font_size = !empty(boxcar_get_config('main-font-size')) ? boxcar_get_config('main-font-size').'px' : '15px';

			$main_font_arr = explode(',', $main_font_family);
			if ( count($main_font_arr) == 1 ) {
				$main_font_family = "'".$main_font_family."'";
			}

			$heading_font = boxcar_get_config('heading-font');
			$heading_font = !empty($heading_font) ? json_decode($heading_font, true) : array();
			$heading_font_family = !empty($heading_font['fontfamily']) ? $heading_font['fontfamily'] : 'DM Sans';
			$heading_font_weight = !empty($heading_font['fontweight']) ? $heading_font['fontweight'] : 700;

			$heading_font_arr = explode(',', $heading_font_family);
			if ( count($heading_font_arr) == 1 ) {
				$heading_font_family = "'".$heading_font_family."'";
			}
			?>
			:root {
			  --boxcar-theme-color: <?php echo trim($main_color); ?>;
			  --boxcar-second-color: <?php echo trim($second_color); ?>;
			  --boxcar-text-color: <?php echo trim($text_color); ?>;
			  --boxcar-link-color: <?php echo trim($link_color); ?>;
			  --boxcar-link-hover-color: <?php echo trim($link_hover_color); ?>;
			  --boxcar-heading-color: <?php echo trim($heading_color); ?>;
			  --boxcar-theme-hover-color: <?php echo trim($main_hover_color); ?>;
			  --boxcar-second-hover-color: <?php echo trim($second_hover_color); ?>;

			  --boxcar-main-font: <?php echo trim($main_font_family); ?>;
			  --boxcar-main-font-size: <?php echo trim($main_font_size); ?>;
			  --boxcar-main-font-weight: <?php echo trim($main_font_weight); ?>;
			  --boxcar-heading-font: <?php echo trim($heading_font_family); ?>;
			  --boxcar-heading-font-weight: <?php echo trim($heading_font_weight); ?>;

			  --boxcar-theme-color-005: <?php echo boxcar_generate_rgba($main_color_rgb, 0.05); ?>
			  --boxcar-theme-color-007: <?php echo boxcar_generate_rgba($main_color_rgb, 0.07); ?>
			  --boxcar-theme-color-010: <?php echo boxcar_generate_rgba($main_color_rgb, 0.1); ?>
			  --boxcar-theme-color-020: <?php echo boxcar_generate_rgba($main_color_rgb, 0.2); ?>
			  --boxcar-second-color-050: <?php echo boxcar_generate_rgba($second_color_rgb, 0.5); ?>
			}
			
			<?php if (  boxcar_get_config('header_mobile_color') != "" ) : ?>
				#apus-header-mobile {
					background-color: <?php echo esc_html( boxcar_get_config('header_mobile_color') ); ?>;
				}
			<?php endif; ?>

	<?php
		$content = ob_get_clean();
		$content = str_replace(array("\r\n", "\r"), "\n", $content);
		$lines = explode("\n", $content);
		$new_lines = array();
		foreach ($lines as $i => $line) {
			if (!empty($line)) {
				$new_lines[] = trim($line);
			}
		}
		
		return implode($new_lines);
	}
}