<?php
/**
 * Custom Header functionality for Boxcar
 *
 * @package WordPress
 * @subpackage Boxcar
 * @since Boxcar 1.0
 */

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses boxcar_header_style()
 */
function boxcar_custom_header_setup() {
	$color_scheme        = boxcar_get_color_scheme();
	$default_text_color  = trim( $color_scheme[4], '#' );

	/**
	 * Filter Boxcar custom-header support arguments.
	 *
	 * @since Boxcar 1.0
	 *
	 * @param array $args {
	 *     An array of custom-header support arguments.
	 *
	 *     @type string $default_text_color     Default color of the header text.
	 *     @type int    $width                  Width in pixels of the custom header image. Default 954.
	 *     @type int    $height                 Height in pixels of the custom header image. Default 1300.
	 *     @type string $wp-head-callback       Callback function used to styles the header image and text
	 *                                          displayed on the blog.
	 * }
	 */
	add_theme_support( 'custom-header', apply_filters( 'boxcar_custom_header_args', array(
		'default-text-color'     => $default_text_color,
		'width'                  => 954,
		'height'                 => 1300,
		'wp-head-callback'       => 'boxcar_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'boxcar_custom_header_setup' );

if ( ! function_exists( 'boxcar_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog.
 *
 * @since Boxcar 1.0
 *
 * @see boxcar_custom_header_setup()
 */
function boxcar_header_style() {
	return '';
}
endif; // boxcar_header_style

