<?php
get_header();
$sidebar_configs = boxcar_get_blog_layout_configs();
$columns = boxcar_get_config('blog_columns', 1);
$layout = boxcar_get_config( 'blog_display_mode', 'grid-v2' );
$thumbsize = !isset($thumbsize) ? boxcar_get_config( 'blog_item_thumbsize', '540x360' ) : $thumbsize;
boxcar_render_breadcrumbs();
if(!empty($sidebar_configs['right'])){
	$mainclass = 'main-right';
} elseif (!empty($sidebar_configs['left'])){
	$mainclass = 'main-left';
} else {
	$mainclass = '';
}
if (!empty($_GET['style']) && ($_GET['style'] =='full') ){
    $columns = 3;
    $layout = 'grid';
    $sidebar_configs['main'] = array( 'class' => 'col-12' );
    $sidebar_configs['right']['class'] = $sidebar_configs['left']['class'] = 'd-none';
    $thumbsize = '560x360';
} else if (!empty($_GET['style']) && ($_GET['style'] =='list') ){
	$columns = 1;
    $layout = 'list';
    $thumbsize = '400x400';
}
?>
<section id="main-container" class="main-content home-page-default <?php echo apply_filters('boxcar_blog_content_class', 'container');?> inner">
	<?php boxcar_before_content( $sidebar_configs ); ?>
	<div class="row">
		<?php boxcar_display_sidebar_left( $sidebar_configs, 'sticky-lg-top' ); ?>

		<div id="main-content" class="main-blog <?php echo esc_attr($sidebar_configs['main']['class']); ?> <?php echo esc_attr($mainclass); ?>">
			<div id="main" class="site-main layout-blog" role="main">

			<?php if ( have_posts() ) : ?>

				<header class="page-header d-none">
					<?php
						the_archive_title( '<h1 class="page-title">', '</h1>' );
						the_archive_description( '<div class="taxonomy-description">', '</div>' );
					?>
				</header><!-- .page-header -->
				<?php
				if ( empty($sidebar_configs['left']) && empty($sidebar_configs['right']) && boxcar_get_config('blog_archive_top_categories', false) ){
				?>
					<div class="blog-header-categories">
						<?php
						$terms = get_terms(array(
							'taxonomy' => 'category',
							'hide_empty' => true,
						));
						if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
							$selected = '';
							if ( is_category() ) {
								global $wp_query;
								$term =	$wp_query->queried_object;
								if ( isset( $term->term_id) ) {
									$selected = $term->term_id;
								}
							}
							?>
						    <ul class="categories-list d-flex flex-wrap">
							    <?php foreach ( $terms as $term ) { ?>
							        <li><a href="<?php echo get_term_link($term); ?>" class="<?php echo esc_attr($term->term_id == $selected ? 'active' : ''); ?>"><?php echo esc_html($term->name); ?></a></li>
							    <?php } ?>
						    </ul>
						<?php } ?>
					</div>
				<?php } ?>
				<?php 
				get_template_part( 'template-posts/layouts/'.$layout, null, array('columns' => $columns, 'thumbsize' => $thumbsize) );

				// Previous/next page navigation.
				boxcar_paging_nav();

			// If no content, include the "No posts found" template.
			else :
				get_template_part( 'template-posts/content', 'none' );

			endif;
			?>

			</div><!-- .site-main -->
		</div><!-- .content-area -->
		
		<?php boxcar_display_sidebar_right( $sidebar_configs, 'sticky-lg-top' ); ?>
		
	</div>
</section>
<?php get_footer(); ?>