<div id="apus-mobile-menu" class="apus-offcanvas d-xl-none"> 
        <div class="header-top-offcanvas">
            <div class="container">
                <div class="d-flex align-items-center">
                    <?php
                        $logo = boxcar_get_config('media-mobile-logo');
                        $logo_url = !empty($logo) ? $logo : '';
                    ?>
                    <?php if( !empty($logo_url) ): ?>
                        <div class="logo">
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
                                <img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'name' )); ?>">
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="logo logo-theme">
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
                                <img src="<?php echo esc_url_raw( get_template_directory_uri().'/images/logo-white.svg'); ?>" alt="<?php echo esc_attr(get_bloginfo( 'name' )); ?>">
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="ms-auto">
                        <div class="d-flex align-items-center">
                            <?php if ( boxcar_is_wp_cardealer_activated() && boxcar_get_config('header_mobile_login', true) ) { ?>
                                <div class="menu-account-wrapper">
                                    <?php if ( is_user_logged_in() ) {
                                        $page_id = wp_cardealer_get_option('user_dashboard_page_id');
                                        $page_id = WP_CarDealer_Mixes::get_lang_post_id($page_id, 'page');

                                        $user_id = get_current_user_id();
                                        $userdata = get_userdata( $user_id );
                                        ?>
                                        <a class="avatar-wrapper d-flex align-items-center" href="<?php echo esc_url( get_permalink( $page_id ) ); ?>">
                                            <?php echo boxcar_get_avatar($user_id, 40); ?>
                                        </a>
                                        <?php
                                    } else {
                                        $login_page_id = wp_cardealer_get_option('login_page_id');
                                        $login_page_id = WP_CarDealer_Mixes::get_lang_post_id($login_page_id, 'page');
                                        $register_page_id = wp_cardealer_get_option('register_page_id');
                                        $register_page_id = WP_CarDealer_Mixes::get_lang_post_id($register_page_id, 'page');
                                        ?>
                                        <a class="text-white" href="<?php echo esc_url( get_permalink( $login_page_id ) ); ?>"><i class="flaticon-user"></i></a>
                                        <?php
                                    } ?>
                                </div>

                            <?php } ?>
                            <span class="btn-showmenu d-flex align-items-center">
                                <svg class="pre" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                <rect x="1" y="16" width="22" height="2" transform="rotate(-45 1 16)" fill="white"/>
                                <rect x="2" y="3.05176e-05" width="22" height="2" transform="rotate(45 2 3.05176e-05)" fill="white"/>
                                </svg><span class="text text-white"><?php echo esc_html__('Menu','boxcar') ?></span>
                            </span>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <div class="offcanvas-content">
            <div class="middle-offcanvas">
                <nav id="menu-main-menu-navbar" class="navbar navbar-offcanvas for-mobile" role="navigation">
                    <?php
                        $mobile_menu = 'primary';
                        $menus = get_nav_menu_locations();
                        if( !empty($menus['mobile-primary']) && wp_get_nav_menu_items($menus['mobile-primary'])) {
                            $mobile_menu = 'mobile-primary';
                        }
                        $args = array(
                            'theme_location' => $mobile_menu,
                            'container_class' => '',
                            'menu_class' => '',
                            'fallback_cb' => '',
                            'menu_id' => '',
                            'container' => 'div',
                            'container_id' => 'mobile-menu-container',
                            'walker' => new Boxcar_Mobile_Menu()
                        );
                        wp_nav_menu($args);

                    ?>
                </nav>
                <?php if ( boxcar_is_wp_cardealer_activated() && boxcar_get_config('header_mobile_add_listing_btn', true) ) {
                    $page_id = wp_cardealer_get_option('submit_listing_form_page_id');
                    $page_id = WP_CarDealer_Mixes::get_lang_post_id($page_id, 'page');
                ?>
                    <div class="submit-job mt-4">
                        <a class="btn btn-submit btn-theme no-responsive w-100" href="<?php echo esc_url( get_permalink( $page_id ) ); ?>"><?php esc_html_e('Add Listing','boxcar') ?></a>
                    </div>
                <?php } ?>
            </div>            
        </div>
</div>
<div class="over-dark"></div>