<div id="apus-header-mobile" class="header-mobile d-block d-xl-none clearfix">    
    <div class="container">
        <div class="clearfix">
            <div class="d-flex align-items-center">
                    <?php
                        $logo = boxcar_get_config('media-mobile-logo');
                        $logo_url = !empty($logo) ? $logo : '';
                    ?>
                    <?php if( !empty($logo_url) ): ?>
                        <div class="logo">
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                <img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'name' )); ?>">
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="logo logo-theme">
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                <img src="<?php echo esc_url( get_template_directory_uri().'/images/logo-white.svg'); ?>" alt="<?php bloginfo( 'name' ); ?>">
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if ( boxcar_get_config('header_mobile_menu', true) ) { ?>
                        <div class="ms-auto">
                            <div class="d-flex align-items-center">
                                <?php if ( boxcar_is_wp_cardealer_activated() && boxcar_get_config('header_mobile_login', true) ) { ?>
                                    <div class="menu-account-wrapper">
                                        <?php if ( is_user_logged_in() ) {
                                            $page_id = wp_cardealer_get_option('user_dashboard_page_id');
                                            $page_id = WP_CarDealer_Mixes::get_lang_post_id($page_id, 'page');

                                            $user_id = get_current_user_id();
                                            $userdata = get_userdata( $user_id );
                                            ?>
                                            <a class="avatar-wrapper d-flex align-items-center" href="<?php echo esc_url( get_permalink( $page_id ) ); ?>">
                                                <?php echo boxcar_get_avatar($user_id, 40); ?>
                                            </a>
                                            <?php
                                        } else {
                                            $login_page_id = wp_cardealer_get_option('login_page_id');
                                            $login_page_id = WP_CarDealer_Mixes::get_lang_post_id($login_page_id, 'page');
                                            $register_page_id = wp_cardealer_get_option('register_page_id');
                                            $register_page_id = WP_CarDealer_Mixes::get_lang_post_id($register_page_id, 'page');
                                            ?>
                                            <a class="text-white" href="<?php echo esc_url( get_permalink( $login_page_id ) ); ?>"><i class="flaticon-user"></i></a>
                                            <?php
                                        } ?>
                                    </div>

                                <?php } ?>
                                <span class="btn-showmenu d-flex align-items-center">
                                    <i class="vertical-icon pre text-white"></i>
                                    <span class="text text-white"><?php echo esc_html__('Menu','boxcar') ?></span>
                                </span>
                            </div>
                        </div>
                    <?php } ?>
            </div>
        </div>
    </div>
</div>