<?php 
global $post;
$thumbsize = !isset($thumbsize) ? boxcar_get_config( 'blog_item_thumbsize', 'full' ) : $thumbsize;
$thumb = boxcar_display_post_thumb($thumbsize);
$hasthumb = !empty($thumb)?'':' nothumb';
?>
<article <?php post_class('post post-layout post-list-item'.$hasthumb); ?>>
    <div class="flex-middle">
        <?php
            if ( !empty($thumb) ) {
                ?>
                <div class="top-image">
                    <?php boxcar_post_categories_first($post); ?>
                    <?php
                        echo trim($thumb);
                    ?>
                 </div>
                <?php
            }
        ?>
        <div class="col-content">
            <?php if( empty($thumb) ) { ?>
                <?php boxcar_post_categories_first($post); ?>
            <?php } ?>
            <div class="top-detail-info clearfix">
                <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
                    <i class="flaticon-user"></i>
                    <?php echo get_the_author(); ?>
                </a>
                <span class="comments"><i class="flaticon-chat"></i><?php comments_number( esc_html__('0 Comments', 'boxcar'), esc_html__('1 Comment', 'boxcar'), esc_html__('% Comments', 'boxcar') ); ?></span>
                <span class="date">
                    <i class="flaticon-calendar-1"></i>
                    <?php the_time( get_option('date_format', 'd M, Y') ); ?>
                </span>
            </div>
            <?php if (get_the_title()) { ?>
                <h4 class="entry-title">
                    <?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
                        <div class="stick-icon"><i class="ti-pin2"></i></div>
                    <?php endif; ?>
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h4>
            <?php } ?>
            <div class="description visible-lg"><?php echo boxcar_substring( get_the_excerpt(),24, '...' ); ?></div>
            <div class="description hidden-lg"><?php echo boxcar_substring( get_the_excerpt(),12, '...' ); ?></div>

            <div class="more-bottom hidden-xs">
                <a href="<?php the_permalink(); ?>" class="btn-readmore flex-middle"><?php echo esc_html__( 'Read More', 'boxcar' )?> <span class="plus">
                    <svg width="11" height="11" viewBox="0 0 11 11" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                    <path d="M5 0H6V11H5V0Z"/>
                    <path d="M4.37113e-08 6L0 5L11 5V6L4.37113e-08 6Z"/>
                    </svg>
                </span></a>
            </div>
        </div>
    </div>
</article>