<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage Boxcar
 * @since Boxcar 1.0
 */
/*
*Template Name: 404 Page
*/
get_header();
$top_url = boxcar_get_config('404_top_img');
?>
<section class="page-404">
	<div class="top-404"><div class="inner"></div></div>
	<div id="main-container" class="inner">
		<div id="main-content" class="main-page">
			<div class="container">
				<div class="content-inner text-center">
					<?php if( !empty($top_url) ) { ?>
						<img src="<?php echo esc_url( $top_url); ?>" alt="<?php bloginfo( 'name' ); ?>">
					<?php }else{ ?>
						<img src="<?php echo esc_url( get_template_directory_uri().'/images/404.png'); ?>" alt="<?php bloginfo( 'name' ); ?>">
					<?php } ?>
					<div class="slogan">
						<h4 class="title-big">
							<?php
							$title = boxcar_get_config('404_title');
							if ( !empty($title) ) {
								echo esc_html($title);
							} else {
								esc_html_e('Oops! It looks like you\'re lost.', 'boxcar');
							}
							?>
						</h4>
					</div>
					<div class="description">
						<?php
						$description = boxcar_get_config('404_des');
						if ( !empty($description) ) {
							echo esc_html($description);
						} else {
							esc_html_e(' The page you \'re looking for isn\'t available. Try to search again or use the go to.', 'boxcar');
						}
						?>
					</div>
					<div class="return">
						<a class="btn btn-theme btn-outline" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e('Back to Home','boxcar') ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg></a>
					</div>
				</div>
			</div>
		</div><!-- .content-area -->
	</div>
</section>
<?php get_footer(); ?>