<?php
/*
Plugin Name: Techco Core
Plugin URI: https://themeforest.net/user/xpressbuddy
Description: After install the Techco WordPress Theme, you must need to install this "techco-core" first to get all functions of Techco WP Theme.
Author: XpressBuddy
Author URI: http://xpressbuddy.com/
Version: 1.0.2
Text Domain: techco-core
*/
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

$techco_core_data = wp_get_theme();
/**
 * Define Core Path
 */
define( 'TECHCO_CORE_VERSION', (WP_DEBUG) ? time() : $techco_core_data->get('Version'));
define( 'TECHCO_DIR_PATH',plugin_dir_path(__FILE__) );
define( 'TECHCO_DIR_URL',plugin_dir_url(__FILE__) );
define( 'TECHCO_INC_PATH', TECHCO_DIR_PATH . '/inc' );
define( 'TECHCO_PLUGIN_IMG_PATH', TECHCO_DIR_URL . '/assets/img' );

/**
 * Css Framework Load
 */
if ( file_exists(TECHCO_DIR_PATH.'/lib/codestar-framework/codestar-framework.php') ) {
    require_once  TECHCO_DIR_PATH.'/lib/codestar-framework/codestar-framework.php';
}

// Elementor - Remove Font Awesome 
add_action( 'elementor/frontend/after_register_styles',function() {
    foreach( [ 'solid', 'regular', 'brands' ] as $style ) {
      wp_deregister_style( 'elementor-icons-fa-' . $style );
    }
  }, 20 );


/**
 * Deregister Elementor Animation
 *
 * @return void
 */
function techco_de_reg() {
    wp_deregister_style( 'e-animations' );
}
add_action( 'wp_enqueue_scripts', 'techco_de_reg' );
/**
 * Enqueue Admin Style
 *
 * @return void
 */
function techco_enqueue_admin_customstyle() {
    wp_enqueue_style( 'admin-style', TECHCO_DIR_URL . '/assets/css/admin-style.css', false, '1.0.0' );
}
add_action( 'admin_enqueue_scripts', 'techco_enqueue_admin_customstyle' );

// Enqueue Script
add_action('elementor/frontend/after_register_scripts', 'script');
function script(){
    wp_enqueue_script('editor-script', TECHCO_DIR_URL . 'assets/js/editor-script.js', '', '', true);
}

function dequeue_wpml_styles(){
    wp_dequeue_style( 'swiper' );
    wp_deregister_style( 'swiper' );

    wp_dequeue_script( 'swiper' );
    wp_deregister_script( 'swiper' );
}
add_action( 'wp_enqueue_scripts', 'dequeue_wpml_styles', 20 );

/**
 * Script Remove
 *
 * @return  [type]  [return description]
 */
function remove_jquery_sticky() {
		wp_dequeue_script( 'swiper' );
		wp_deregister_script( 'swiper' );
}
add_action( 'elementor/frontend/after_register_scripts', 'remove_jquery_sticky' );



/**
 * Custom Widget
 */
include_once TECHCO_INC_PATH . "/custom-widget/recent-post-widget.php";
include_once TECHCO_INC_PATH . "/custom-widget/top-rated-products-widget.php";

/**
 * Plugin Helper
 */
include_once TECHCO_INC_PATH . "/techco-plugin-helper.php";

/**
 * Themeoption
 */
include_once TECHCO_INC_PATH . "/metabox-and-options/metabox-and-options.php";


/**
 * Helper Function
 */
include_once TECHCO_INC_PATH . "/helper.php";



/**
 * Custom Post
 */
include_once TECHCO_INC_PATH . "/post-type/header-footer.php";
include_once TECHCO_INC_PATH . "/post-type/service.php";
include_once TECHCO_INC_PATH . "/post-type/project.php";


/**
 * Elementor Configuration
 */
include_once TECHCO_DIR_PATH . "/elementor/elementor-init.php";

add_filter('wpcf7_autop_or_not', '__return_false');


if (!class_exists('EFramework_MegaMenu_Register')) {
    require_once TECHCO_DIR_PATH . '/inc/mega-menu/class-megamenu.php';
    EFramework_MegaMenu_Register::get_instance();
}
