<?php
if ( !function_exists( 'techco_service' ) ) {

// Register Services
    function techco_service() {

        $labels = array(
            'name'                  => esc_html_x( 'Services', 'Post Type General Name', 'techco-core' ),
            'singular_name'         => esc_html_x( 'Service', 'Post Type Singular Name', 'techco-core' ),
            'menu_name'             => esc_html__( 'Services', 'techco-core' ),
            'name_admin_bar'        => esc_html__( 'Services', 'techco-core' ),
            'archives'              => esc_html__( 'Item Archives', 'techco-core' ),
            'attributes'            => esc_html__( 'Item Attributes', 'techco-core' ),
            'parent_item_colon'     => esc_html__( 'Parent Item:', 'techco-core' ),
            'all_items'             => esc_html__( 'All Services', 'techco-core' ),
            'add_new_item'          => esc_html__( 'Add New Service', 'techco-core' ),
            'add_new'               => esc_html__( 'Add New Service', 'techco-core' ),
            'new_item'              => esc_html__( 'New Service', 'techco-core' ),
            'edit_item'             => esc_html__( 'Edit Service', 'techco-core' ),
            'update_item'           => esc_html__( 'Update Service', 'techco-core' ),
            'view_item'             => esc_html__( 'View Services', 'techco-core' ),
            'view_items'            => esc_html__( 'View Services', 'techco-core' ),
            'search_items'          => esc_html__( 'Search Service', 'techco-core' ),
            'not_found'             => esc_html__( 'Not found', 'techco-core' ),
            'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'techco-core' ),
            'featured_image'        => esc_html__( 'Featured Image', 'techco-core' ),
            'set_featured_image'    => esc_html__( 'Set featured image', 'techco-core' ),
            'remove_featured_image' => esc_html__( 'Remove featured image', 'techco-core' ),
            'use_featured_image'    => esc_html__( 'Use as featured image', 'techco-core' ),
            'insert_into_item'      => esc_html__( 'Insert into item', 'techco-core' ),
            'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'techco-core' ),
            'items_list'            => esc_html__( 'Items list', 'techco-core' ),
            'items_list_navigation' => esc_html__( 'Items list navigation', 'techco-core' ),
            'filter_items_list'     => esc_html__( 'Filter items list', 'techco-core' ),
        );
        $args = array(
            'label'               => esc_html__( 'Services', 'techco-core' ),
            'description'         => esc_html__( 'Add Service Here', 'techco-core' ),
            'labels'              => $labels,
            'supports'            => array( 'title', 'thumbnail', 'elementor' ),
            'hierarchical'        => false,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'menu_position'       => 20,
            'menu_icon'           => 'dashicons-hammer',
            'show_in_admin_bar'   => true,
            'show_in_nav_menus'   => true,
            'can_export'          => true,
            'has_archive'         => false,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'page',
            'rewrite'               => array( 'slug' => 'service' ),
        );
        register_post_type( 'techco_service', $args );

    }
    add_action( 'init', 'techco_service', 0 );

}

/**
 * Project Custom Taxonomy
 */

if ( !function_exists( 'techco_service_tax' ) ) {
    function techco_service_tax() {
        $labels = [
            'name'          => esc_html__( 'Categories', 'techco-core' ),
            'menu_name'     => esc_html__( 'Categories', 'techco-core' ),
            'singular_name' => esc_html__( 'Category', 'techco-core' ),
            'search_items'  => esc_html__( 'Search Category', 'techco-core' ),
            'all_items'     => esc_html__( 'All Category', 'techco-core' ),
            'new_item_name' => esc_html__( 'New Category', 'techco-core' ),
            'add_new_item'  => esc_html__( 'Add New Category', 'techco-core' ),
            'edit_item'     => esc_html__( 'Edit New Category', 'techco-core' ),
            'update_item'   => esc_html__( 'Update New Category', 'techco-core' ),
        ];
        $args = array(
            'labels'                => $labels,
            'hierarchical'          => true,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'query_var'             => true,
            'update_count_callback' => '_update_post_term_count',
            'rewrite'               => array( 'slug' => 'service-category' ),
        );
        register_taxonomy( 'service_cat', 'techco_service', $args );
    }
    add_action( 'init', 'techco_service_tax' );
}