<?php

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

/*
 *  Create theme options
 */

$techco_theme_option = 'techco_theme_options';

// Create options
CSF::createOptions( $techco_theme_option, array(
    'framework_title' => wp_kses(
        sprintf(__("Techco Options <small>V %s</small>", 'xpress core'), $techco_core_data->get('Version')),
        array('small' => array())
    ),
	'menu_title'      => __('Theme Options','techco-core'),
	'menu_slug'       => 'techco-options',
    'enqueue_webfont'    => true,
    'show_in_customizer' => true,
    'menu_icon' => 'dashicons-category',
	'show_sub_menu'   => false,
	'class'           => 'techco-theme-option',
	'menu_position'   =>3,
	'footer_text'   => wp_kses(
		__( 'Developed by: <a target="_blank" href="https://xpressbuddy.com">XpressBuddy</a>', 'techco-core' ),
		array(
			'a'      => array(
				'href'   => array(),
				'target' => array()
			),
		)
	),
	'async_webfont' => false,
) );

/*
 * General options
 */
require_once 'general-options.php';

/*
 * Typography options
 */
require_once 'typography-options.php';


/*
 * Header options
 */
require_once 'header-options.php';

/*
 * Banner options
 */
require_once 'banner-options.php';

/*
 * Page Options
 */
require_once 'page-options.php';


/*
 * Blog page options
 */
require_once 'blog-page-options.php';

/*
 * Signle Post options
 */
require_once 'single-post-options.php';

/*
 * Service options
 */
require_once 'service-option.php';

/*
 * Project options
 */
require_once 'project-option.php';

/*
 * Archive Page Options
 */
require_once 'archive-page-options.php';

/*
 * Search Page Options
 */
require_once 'search-page-options.php';

/*
 * Error 404 Page Options
 */
require_once 'error-page-options.php';

/*
 * Footer options
 */
require_once 'footer-options.php';

// Custom Css section
CSF::createSection( $techco_theme_option, array(
	'title'  => esc_html__( 'Custom Css', 'techco-core' ),
	'id'     => 'custom_css_options',
	'icon'   => 'fa fa-css3',
	'fields' => array(

		array(
			'id'       => 'techco_custom_css',
			'type'     => 'code_editor',
			'title'    => esc_html__( 'Custom Css', 'techco-core' ),
			'settings' => array(
				'theme'  => 'mbo',
				'mode'   => 'css',
			),
			'sanitize' => false,
		),
	)
) );


/*
 * Backup options
 */
CSF::createSection($techco_theme_option, array(
	'title'  => esc_html__('Backup', 'techco-core'),
	'id'     => 'backup_options',
	'icon'   => 'fa fa-window-restore',
	'fields' => array(
		array(
			'type' => 'backup',
		),
	)
));

