<?php
//Search Options

CSF::createSection( $techco_theme_option, array(
	'title'  => esc_html__( 'Search Page', 'techco-core' ),
	'id'     => 'search_page_options',
	'icon'   => 'fa fa-search',
	'fields' => array(

		array(
			'id'      => 'search_layout',
			'type'    => 'select',
            'chosen'      => true,
			'title'   => esc_html__( 'Search Layout', 'techco-core' ),
			'options' => array(
				'grid'          => esc_html__( 'Grid Full', 'techco-core' ),
				'grid-ls'       => esc_html__( 'Grid With Left Sidebar', 'techco-core' ),
				'grid-rs'       => esc_html__( 'Grid With Right Sidebar', 'techco-core' ),
				'left-sidebar'  => esc_html__( 'Left Sidebar', 'techco-core' ),
				'right-sidebar' => esc_html__( 'Right Sidebar', 'techco-core' ),
			),
			'default' => 'right-sidebar',
			'desc'    => esc_html__( 'Select search page layout.', 'techco-core' ),
		),

		array(
			'id'       => 'search_banner',
			'type'     => 'switcher',
			'title'    => esc_html__( 'Enable Search Banner', 'techco-core' ),
			'default'  => true,
			'text_on'  => esc_html__( 'Yes', 'techco-core' ),
			'text_off' => esc_html__( 'No', 'techco-core' ),
			'desc'     => esc_html__( 'Enable or disable search page banner.', 'techco-core' ),
		),

		array(
			'id'                    => 'search_banner_background_options',
			'type'                  => 'background',
			'title'                 => esc_html__( 'Banner Background', 'techco-core' ),
			'background_gradient'   => true,
			'background_origin'     => false,
			'background_clip'       => false,
			'background_blend-mode' => false,
			'background_attachment' => false,
			'background_size'       => false,
			'background_position'   => false,
			'background_repeat'     => false,
			'dependency'            => array( 'search_banner', '==', true ),
			'output'                => '.breadcrumb.search-banner',
			'desc'                  => esc_html__( 'If you want different banner background settings for search page then select search page banner background options from here.', 'techco-core' ),
		),

	)
) );