<?php

// Create Page Options
CSF::createSection( $techco_theme_option, array(
	'title'  => esc_html__( 'Page Options', 'techco-core' ),
	'id'     => 'page_options',
	'icon'   => 'fa fa-file-text-o',
	'fields' => array(
		array(
			'id'      => 'page_default_layout',
			'type'    => 'select',
            'chosen'      => true,
			'title'   => esc_html__('Page Layout', 'techco-core'),
			'options' => array(
				'full-width'  => esc_html__('Full Width', 'techco-core'),
				'left-sidebar'  => esc_html__('Left Sidebar', 'techco-core'),
				'right-sidebar' => esc_html__('Right Sidebar', 'techco-core'),
			),
			'default' => 'full-width',
			'desc'    => esc_html__('Select page layout.', 'techco-core'),
		),

		array(
			'id'         => 'page_default_sidebar',
			'type'       => 'select',
			'title'      => esc_html__( 'Sidebar', 'techco-core' ),
			'options'    => 'techco_sidebars',
			'default' => 'sidebar',
			'dependency' => array( 'page_default_layout', '!=', 'full-width' ),
			'desc'       => esc_html__( 'Select default sidebar for all pages. You can override this settings on individual page.', 'techco-core' ),
		),
	)
) );