<?php
// Create header Settings section
CSF::createSection( $techco_theme_option, array(
    'title' => esc_html__( 'Header Settings', 'xpress-core' ),
    'id'    => 'header_options',
    'icon'  => 'fa fa-header',
    'fields' => array(
        array(
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( 'Header Layout', 'techco-tools' ) . '</h3>',
        ),

        array(
            'id'          => 'header_style',
            'type'        => 'select',
            'chosen'      => true,
            'title'       => __('Select Header Style', 'techco-tools' ),
            'options'     => Techco_Plugin_Helper::get_header_types(),
        ),

        array(
            'id' =>'header_default_logo',
            'type'=>'media',
            'title'=>esc_html__( 'Header Logo', 'techco-core' ),
            'library'      => 'image',
            'url'          => false,
            'button_title' => esc_html__( 'Upload Logo', 'techco-core' ),
            'desc'         => esc_html__( 'Upload logo image', 'techco-core' ),
        ),

        array(
            'id'          => 'logo_maximum_width',
            'type'        => 'slider',
            'title'       => esc_html__( 'Logo Maximum Width', 'techco-core' ),
            'min'         => 50,
            'max'         => 500,
            'step'        => 1,
            'unit'        => 'px',
            'output'      => '.header-logo img',
            'output_mode' => 'max-width',
            'desc'        => esc_html__( 'Logo image maximum width', 'techco-core' ),
        ),
    )
) );