<?php

// Create general section
CSF::createSection( $techco_theme_option, array(
	'title'  => esc_html__( 'General Options', 'techco-core' ),
	'id'     => 'general_options',
	'icon'   => 'fa fa-google',
	'fields' => array(

		array(
			'id'     => 'theme_primary_color',
			'type'   => 'color',
			'title'  => esc_html__( 'Primary Color', 'techco-core' ),
			'desc'   => esc_html__( 'You can change other colors from individual Elemenotor widget\'settings.', 'techco-core' ),
		),
		array(
			'id'     => 'theme_secondary_color',
			'type'   => 'color',
			'title'  => esc_html__( 'Secondary Color', 'techco-core' ),
			'desc'   => esc_html__( 'You can change other colors from individual Elemenotor widget\'settings.', 'techco-core' ),
		),
        array(
            'id'      => 'scroll_up_btn',
            'title'   => esc_html__( 'Scroll Up Button', 'techco-core' ),
            'type'    => 'switcher',
            'desc'    => esc_html__( 'Scroll Up Button Hide Show', 'techco-core' ),
            'default' => true,
        ),
        array(
            'id'      => 'preloader_enable',
            'title'   => esc_html__( 'Enable Preloader', 'techco-core' ),
            'type'    => 'switcher',
            'desc'    => esc_html__( 'Enable or Disable Preloader', 'techco-core' ),
            'default' => true,
        ),
        array(
            'id'                    => 'preloader_logo',
            'type'                  => 'background',
            'title'                 => esc_html__( 'Preloader Logo', 'techco-core' ),
            'background_origin'     => false,
            'background_clip'       => false,
            'background_blend-mode' => false,
            'background_attachment' => false,
            'background_size' => false,
            'background_position' => false,
            'background_repeat' => false,
            'output'                => '.preloader .loader-logo',
            'desc'        => esc_html__('Upload Preloader Logo.', 'techco-core'),
            'dependency' => array( 'preloader_enable', '==', 'true' ),
        ),
        array(
            'id'          => 'preloader_logo_width',
            'type'        => 'slider',
            'title'       => esc_html__( 'Preloader Logo Width', 'techco-core' ),
            'min'         => 50,
            'max'         => 500,
            'step'        => 1,
            'unit'        => 'px',
            'output'      => '.preloader .loader-logo',
            'output_mode' => 'background-size',
            'desc'        => esc_html__( 'Logo image width', 'techco-core' ),
        ),
        array(
            'id'      => 'sticky_header_enable',
            'title'   => esc_html__( 'Enable Stikcy Header', 'techco-core' ),
            'type'    => 'switcher',
            'desc'    => esc_html__( 'Enable or Disable Stikcy Header', 'techco-core' ),
            'default' => true,
        ),
	)
) );