<?php

// Create blog page options
CSF::createSection( $techco_theme_option, array(
	'title'  => esc_html__( 'Blog Page', 'techco-core' ),
	'id'     => 'blog_page_options',
	'icon'   => 'fa fa-pencil-square-o',
	'fields' => array(

		array(
			'id'      => 'blog_layout',
			'type'    => 'select',
            'chosen'      => true,
			'title'   => esc_html__('Blog Layout', 'techco-core'),
			'options' => array(
				'grid'          => esc_html__('Grid Full', 'techco-core'),
				'grid-ls'       => esc_html__('Grid With Left Sidebar', 'techco-core'),
				'grid-rs'       => esc_html__('Grid With Right Sidebar', 'techco-core'),
				'left-sidebar'  => esc_html__('Left Sidebar', 'techco-core'),
				'right-sidebar' => esc_html__('Right Sidebar', 'techco-core'),
			),
			'default' => 'right-sidebar',
			'desc'    => esc_html__('Select blog page layout.', 'techco-core'),
		),

		array(
			'id'       => 'blog_banner',
			'type'     => 'switcher',
			'title'    => esc_html__('Enable Blog Banner', 'techco-core'),
			'default'  => true,
			'text_on'  => esc_html__('Yes', 'techco-core'),
			'text_off' => esc_html__('No', 'techco-core'),
			'desc'     => esc_html__('Enable or disable blog page banner.', 'techco-core'),
		),

		array(
			'id'                    => 'blog_banner_background_options',
			'type'                  => 'background',
			'title'                 => esc_html__('Banner Background', 'techco-core'),
			'background_origin'     => false,
			'background_clip'       => false,
			'background_blend-mode' => false,
			'background_attachment' => false,
			'background_size' => false,
			'background_position' => false,
			'background_repeat' => false,
			'dependency'            => array('blog_banner', '==', true),
			'output'                => '.breadcrumb.blog-banner',
			'desc'                  => esc_html__('If you want different banner background settings for blog page then select blog page banner background Options from here.', 'techco-core'),
		),

		array(
			'id'         => 'blog_title',
			'type'       => 'text',
			'title'      => esc_html__('Banner Title', 'techco-core'),
			'desc'       => esc_html__('Type blog banner title here.', 'techco-core'),
            'default'         => esc_html__( 'Blog', 'techco-core' ),
			'dependency' => array('blog_banner', '==', true),
		),

		array(
			'id'       => 'post_author',
			'type'     => 'switcher',
			'title'    => esc_html__('Show Author Name', 'techco-core'),
			'default'  => true,
			'text_on'  => esc_html__('Yes', 'techco-core'),
			'text_off' => esc_html__('No', 'techco-core'),
			'desc'     => esc_html__('Hide / Show post author name.', 'techco-core'),
		),

		array(
			'id'       => 'post_date',
			'type'     => 'switcher',
			'title'    => esc_html__('Show Post Date', 'techco-core'),
			'default'  => true,
			'text_on'  => esc_html__('Yes', 'techco-core'),
			'text_off' => esc_html__('No', 'techco-core'),
			'desc'     => esc_html__('Hide / Show post date.', 'techco-core'),
		),

		array(
			'id'         => 'show_category',
			'type'       => 'switcher',
			'title'      => esc_html__('Show Category Name', 'techco-core'),
			'default'    => false,
			'text_on'    => esc_html__('Yes', 'techco-core'),
			'text_off'   => esc_html__('No', 'techco-core'),
			'desc'       => esc_html__('Hide / Show post category name.', 'techco-core'),
			'dependency' => array('blog_layout', 'any', 'right-sidebar,left-sidebar'),
		),

		array(
			'id'         => 'read_more_button',
			'type'       => 'switcher',
			'title'      => esc_html__('Show Read More Button', 'techco-core'),
			'default'    => true,
			'text_on'    => esc_html__('Yes', 'techco-core'),
			'text_off'   => esc_html__('No', 'techco-core'),
			'desc'       => esc_html__('Hide / Show post read more button.', 'techco-core'),
		),
        array(
            'id'     => 'blog_shape',
            'type'   => 'fieldset',
            'title'  => 'Blog Shape',
            'fields' => array(
                array(
                    'id' =>'shape1',
                    'type'=>'media',
                    'title'=>esc_html__( 'Shape 1', 'techco-core' ),
                    'library'      => 'image',
                    'url'          => false,
                    'button_title' => esc_html__( 'Upload Icon', 'techco-core' ),
                    'desc'         => esc_html__( 'Upload icon image', 'techco-core' ),
                ),
                array(
                    'id' =>'shape2',
                    'type'=>'media',
                    'title'=>esc_html__( 'Shape 2', 'techco-core' ),
                    'library'      => 'image',
                    'url'          => false,
                    'button_title' => esc_html__( 'Upload Icon', 'techco-core' ),
                    'desc'         => esc_html__( 'Upload icon image', 'techco-core' ),
                ),
                array(
                    'id' =>'shape3',
                    'type'=>'media',
                    'title'=>esc_html__( 'Shape 3', 'techco-core' ),
                    'library'      => 'image',
                    'url'          => false,
                    'button_title' => esc_html__( 'Upload Icon', 'techco-core' ),
                    'desc'         => esc_html__( 'Upload icon image', 'techco-core' ),
                ),
                array(
                    'id' =>'shape4',
                    'type'=>'media',
                    'title'=>esc_html__( 'Shape 4', 'techco-core' ),
                    'library'      => 'image',
                    'url'          => false,
                    'button_title' => esc_html__( 'Upload Icon', 'techco-core' ),
                    'desc'         => esc_html__( 'Upload icon image', 'techco-core' ),
                ),
                array(
                    'id' =>'shape5',
                    'type'=>'media',
                    'title'=>esc_html__( 'Shape 5', 'techco-core' ),
                    'library'      => 'image',
                    'url'          => false,
                    'button_title' => esc_html__( 'Upload Icon', 'techco-core' ),
                    'desc'         => esc_html__( 'Upload icon image', 'techco-core' ),
                ),
            ),
        ),
	)
) );