<?php

// Create banner options
CSF::createSection($techco_theme_option, array(
	'title'  => esc_html__('Banner Options', 'techco-core'),
	'id'     => 'banner_default_options',
	'icon'   => 'fa fa-flag-o',
	'fields' => array(

        array(
            'id'                    => 'banner_default_background',
            'type'                  => 'background',
            'title'                 => esc_html__( 'Banner Background', 'techco-core' ),
            'background_origin'     => false,
            'background_clip'       => false,
            'background_blend-mode' => false,
            'background_attachment' => false,
            'background_size' => false,
            'background_position' => false,
            'background_repeat' => false,
            'output'                => '.breadcrumb',
            'desc'                  => esc_html__( 'Select banner background color and image. You can change this settings on individual page / post.', 'techco-core' ),
        ),

		array(
			'id'         => 'banner_default_text_align',
			'type'       => 'button_set',
			'title'      => esc_html__( 'Banner Text Align', 'techco-core' ),
			'options'    => array(
				'start'   => esc_html__( 'Left', 'techco-core' ),
				'center' => esc_html__( 'Center', 'techco-core' ),
				'end'  => esc_html__( 'Right', 'techco-core' ),
			),
			'default'    => 'center',
			'desc'       => esc_html__( 'Select banner text align. You can change this settings on individual page / post.', 'techco-core' ),
		),

		array(
			'id'          => 'banner_default_height',
			'type'        => 'slider',
			'title'       => esc_html__('Banner Height', 'techco-core'),
			'min'         => 100,
			'max'         => 800,
			'step'        => 1,
			'unit'        => 'px',
			'output'      => '.breadcrumb',
			'output_mode' => 'height',
			'desc'        => esc_html__('Select banner height. You can change this settings on individual page / post.', 'techco-core'),
		),
	)
));