<?php
// Video Post Meta
$techco_video_post_meta = 'techco_video_post_format_meta';

CSF::createMetabox( $techco_video_post_meta, array(
	'title'        => esc_html__('Video Post Format Options', 'techco-core' ),
	'post_type'    => 'post',
	'post_formats' => array('video'),
) );

CSF::createSection( $techco_video_post_meta, array(
	'fields' => array(

		array(
			'id'    => 'post_video_url',
			'type'  => 'text',
			'title' => esc_html__('Video URL', 'techco-core' ),
			'desc'    => esc_html__( 'Paste video URL here', 'techco-core' ),
		),

	)
));

// Audio Post Meta
$techco_audio_post_meta = 'audio_post_format_meta';

CSF::createMetabox( $techco_audio_post_meta, array(
	'title'        => esc_html__('Audio Post Format Options', 'techco-core' ),
	'post_type'    => 'post',
	'post_formats' => array('audio'),
) );

CSF::createSection( $techco_audio_post_meta, array(
	'fields' => array(

		array(
			'id'    => 'audio_embed_code',
			'type'  => 'code_editor',
			'settings' => array(
				'theme'  => 'monokai',
				'mode'   => 'htmlmixed',
			),
			'title' => esc_html__('Audio Embed Code', 'techco-core' ),
			'desc'    => esc_html__( 'Paste sound cloud audio embed code here', 'techco-core' ),
		),

	)
));


// Gallery Post Meta
$techco_gallery_post_meta = 'gallery_post_format_meta';

CSF::createMetabox( $techco_gallery_post_meta, array(
	'title'        => esc_html__('Gallery Post Format Options', 'techco-core' ),
	'post_type'    => 'post',
	'post_formats' => array('gallery'),
) );

CSF::createSection( $techco_gallery_post_meta, array(
	'fields' => array(

		array(
			'id'          => 'post_gallery_images',
			'type'        => 'gallery',
			'title' => esc_html__('Gallery Images', 'techco-core' ),
			'add_title'   => esc_html__('Upload Gallery Images', 'techco-core'),
			'edit_title'  => esc_html__('Edit Gallery Images', 'techco-core'),
			'clear_title' => esc_html__('Remove Gallery Images', 'techco-core'),
			'desc'    => esc_html__( 'Upload gallery images from here', 'techco-core' ),
		),

	)
));